<?php
$this->extend('BuzzDiaryAccounts./Common/diary');
?>

<h2><?php echo __d('buzz_diary_accounts', 'Are you sure you want to cancel this payment request?'); ?></h2>

<div class="row">
	<div class="col-xs-12 col-sm-8 diary-accounts__my-account">

		<table class="table--centralised">
			<tr>
				<th><?php echo __d('buzz_diary_accounts', 'Amount'); ?></th>
				<td><?php echo $this->Number->currency($data['AccountPaymentRequest']['amount']); ?></td>
			</tr>
			<tr>
				<th><?php echo __d('buzz_diary_accounts', 'Name'); ?></th>
				<td><?php echo $data['AccountPaymentRequest']['name']; ?></td>
			</tr>
			<tr>
				<th><?php echo __d('buzz_diary_accounts', 'Email'); ?></th>
				<td><?php echo $data['AccountPaymentRequest']['email_address']; ?></td>
			</tr>
			<tr>
				<th><?php echo __d('buzz_diary_accounts', 'Reference'); ?></th>
				<td><?php echo $data['AccountPaymentRequest']['reference']; ?></td>
			</tr>
		</table>

		<?php echo $this->Form->create('AccountPaymentRequest'); ?>
		<?php echo $this->Form->input('AccountPaymentRequest.id'); ?>

		<div class="text-center">
			<?php echo $this->Form->button(__d('buzz_diary_accounts', 'Cancel Payment Request') . ' <i class="fa fa-chevron-circle-right"></i>', ['class' => 'button button--center']); ?>
		</div>

		<?php echo $this->Form->end(); ?>

		<div class="content__spacer xs-visible"></div>

	</div>
</div>
