<?php
$this->extend('BuzzDiaryAccounts./Common/diary');
?>

<h2><?php echo __d('buzz_diary_accounts', 'Request a Payment'); ?></h2>

<div class="row">
	<div class="col-xs-12 col-sm-9 diary-accounts__credits__request">

		<?php echo $this->Form->create('AccountPaymentRequest', ['class' => 'form--side-labels validate disable-button-during-submit']); ?>

			<?php
				echo $this->Form->input(
					'amount',
					[
						'label' => __d('buzz_diary_accounts', 'Amount (%s)', [$this->Number->currencySymbol()]),
						'div' => 'input number',
						'required' => false
					]
				);
				echo $this->Form->input(
					'name',
					['label' => __d('buzz_diary_accounts', 'Name')]
				);
				echo $this->Form->input(
					'email_address',
					['label' => __d('buzz_diary_accounts', 'Email')]
				);
				echo $this->Form->input(
					'reference',
					['label' => __d('buzz_diary_accounts', 'Reference')]
				);
				echo $this->Form->input(
					'description',
					['label' => __d('buzz_diary_accounts', 'Description (included in request email)'), 'type' => 'textarea']
				);

				echo $this->Form->button(
					__d('buzz_diary_accounts', 'Request Payment') . '<i class="fa fa-chevron-circle-right fa-inline"></i>',
					['class' => 'button']
				);
			?>

		<?php echo $this->Form->end(); ?>

	</div>
</div>
