<?php
$this->extend('BuzzDiaryAccounts./Common/diary');
echo $this->Html->css(['BuzzDiaryAccounts.buzz_diary_accounts.min'], ['inline' => false]);
?>

<div class="row overview">
	<div class="col-xs-12 col-sm-8">
		<h3><?php echo __d('buzz_diary_accounts', 'Credits Added') ?></h3>
	</div>
	<div class="col-xs-12 col-sm-4 xs-text-left text-right">
		<?php echo $this->Fa->link('chevron-circle-right fa-inline', __d('buzz_diary_accounts', 'View All Credits'), ['action' => 'history'], ['class' => 'overview__link', 'space' => false]); ?>
	</div>
	<div class="col-xs-12 overview__details ajax-loader" data-src="<?php echo $this->Html->url(['action' => 'get_credits']); ?>">
	</div>
	<?php if (! empty($accountUser['Account']['can_add_credit'])): ?>
		<div class="col-xs-12">
			<?php echo $this->Fa->link('chevron-circle-right fa-inline', __d('buzz_diary_accounts', 'Add Credit'), ['action' => 'add'], ['class' => 'button cf', 'space' => false]); ?>
		</div>
	<?php endif; ?>
</div>

<?php if (!empty($accountUser['Account']['can_request_payments'])): ?>
	<div class="row">
		<div class="col-xs-12 col-sm-8">
			<h3><?php echo __d('buzz_diary_accounts', 'Outstanding Payment Requests') ?></h3>
		</div>
		<div class="col-xs-12 col-sm-4 xs-text-left text-right">
			<?php echo $this->Fa->link('chevron-circle-right fa-inline', __d('buzz_diary_accounts', 'View All Outstanding Requests'), ['action' => 'index', 'controller' => 'account_payment_requests'], ['class' => 'overview__link', 'space' => false]); ?>
		</div>
		<div class="col-xs-12">
			<?php echo $this->element('BuzzDiaryAccounts.payment_requests_table'); ?>
		</div>
		<div class="col-xs-12">
			<?php echo $this->Fa->link('chevron-circle-right fa-inline', __d('buzz_diary_accounts', 'Request Payment'), ['action' => 'add', 'controller' => 'account_payment_requests'], ['class' => 'button cf', 'space' => false]); ?>
		</div>
	</div>
<?php endif; ?>
<?php if (! empty($ecommerceTracking)): ?>
	<?= $this->element('BuzzPurchase.ecommerce_tracking', [
			'total' => $ecommerceTracking['revenue'],
			'ecommerceTracking' => $ecommerceTracking,
		]);
	?>
<?php endif; ?>
