<?php
$this->extend('BuzzDiaryAccounts./Common/diary');
$this->assign('title', 'Pro Flyer Bulk Booking');
?>

<div class="row">
	<div class="col-xs-12 col-sm-9 diary-accounts__credits__add">

		<?php echo $this->Form->create('AccountCredit', ['class' => 'form--side-labels validate']); ?>

		<h3><?php echo __d('buzz_diary_accounts', 'Credit Amount'); ?></h3>
		<?php
			echo $this->Form->input(
				'AccountCredit.amount',
				[
					'label' => __d('buzz_diary_accounts', 'Amount (%s)', [$this->Number->currencySymbol()]),
					'div' => 'input number'
				]
			);
		?>

		<?php if (Configure::read('BuzzPurchase.onsite') === true): ?>
			<h3><?php echo __d('buzz_diary_accounts', 'Payment Details'); ?></h3>
			<?php echo $this->element('BuzzPurchase.Forms/payment_form'); ?>
		<?php endif; ?>

		<h3><?php echo __d('buzz_diary_accounts', 'Billing Details'); ?></h3>
		<?php echo $this->Element('BuzzCustomers.address_form'); ?>
		<?php echo $this->Form->input('CustomerAddress.email', ['label' => __d('buzz_diary_accounts', 'Email')]); ?>
		<?php echo $this->Form->input('CustomerAddress.telephone', ['label' => __d('buzz_diary_accounts', 'Telephone')]); ?>

		<?php echo $this->Form->button(__d('buzz_diary_accounts', 'Add Credit') . '<i class="fa fa-chevron-circle-right fa-inline"></i>', ['class' => 'button']); ?>

		<?php echo $this->Form->end(); ?>

	</div>
</div>
