<?php

class DiaryApiTest extends CakeTestCase {

	public function setUp() {
		parent::setUp();
		$this->DiaryApi = ClassRegistry::init('BuzzDiaryAccounts.DiaryApi');
		// We're not directly testing the API as the test data isn't reliable
		// so we want to switch the DB config for test to avoid errors.
		$this->DiaryApi->useDbConfig = 'test';
	}

/**
 * Make protected methods accessible for testing
 *
 * @param string $name Method name
 * @return object
 */
	public static function getMethod($name) {
		$DiaryApi = new ReflectionClass('DiaryApi');
		$method = $DiaryApi->getMethod($name);
		$method->setAccessible(true);
		return $method;
	}

/**
 * Test processing of account credit history
 *
 * @return void
 */
	public function testCreditHistory() {
		// Get sample credit data
		$data = $this->_apiUserAccountCreditHistoryResponse();

		$processUserAccountCreditHistory = self::getMethod('_processUserAccountCreditHistory');
		$result = $processUserAccountCreditHistory->invokeArgs($this->DiaryApi, [$data['DiaryApi']['d']]);
		$this->assertInternalType('array', $result);
		$this->assertEquals('joe@example.com', $result[0]['extras']['email_address']);

		return;
	}

/**
 * Test processing of account bookings
 *
 * @return void
 */
	public function testBookings() {
		// Get sample bookings data
		$data = $this->_apiUserAccountBookingsResponse();

		$processUserAccountBookings = self::getMethod('_processUserAccountBookings');
		$result = $processUserAccountBookings->invokeArgs($this->DiaryApi, [$data['DiaryApi']['d']]);
		$this->assertInternalType('array', $result);

		return;
	}

/**
 * Test processing of account bookings
 *
 * @return void
 */
	public function testDiarySlots() {
		// Get sample diary slots data
		$data = $this->_apiGetAvailableDiarySlotsResponse();

		$processDiarySlots = self::getMethod('_processDiarySlots');
		$result = $processDiarySlots->invokeArgs($this->DiaryApi, [$data['DiaryApi']['d']]);
		$this->assertInternalType('array', $result['Template']['10:00:00']);

		return;
	}

/**
 * Sample data from API for testing
 *
 * @return array
 */
	protected function _apiUserAccountCreditHistoryResponse() {
		return array(
			'DiaryApi' => array(
				'd' => array(
					0 => array(
						'__type' => 'UserAccountCreditHistoryData:#BookingSystem.OnLineDiary',
						'Balance' => '200',
						'Notes' => '{"name":"Joe Bloggs","email_address":"joe@example.com","telephone":"0123456789","reference":"Test Camp"} joe@example.com',
						'ContactName' => null,
						'Purchased' => '200',
						'Reference' => 'S762481',
						'SalesDate' => '27/03/2015'
					),
					1 => array(
						'__type' => 'UserAccountCreditHistoryData:#BookingSystem.OnLineDiary',
						'Balance' => '1200',
						'Notes' => '{"name":"Andy","email_address":"joe@example.com","reference":"TEST 27\/03\/15"} joe@example.com',
						'ContactName' => null,
						'Purchased' => '1000',
						'Reference' => 'S762480',
						'SalesDate' => '27/03/2015'
					),
					2 => array(
						'__type' => 'UserAccountCreditHistoryData:#BookingSystem.OnLineDiary',
						'Balance' => '1300',
						'Notes' => 'joe@example.com',
						'ContactName' => null,
						'Purchased' => '100',
						'Reference' => 'S762474',
						'SalesDate' => '26/03/2015'
					)
				)
			)
		);
	}

/**
 * Sample data from API for testing
 *
 * @return array
 */
	protected function _apiUserAccountBookingsResponse() {
		return array(
			'DiaryApi' => array(
				'd' => array(
					array(
						'__type' => 'UserAccountBookingData:#BookingSystem.OnLineDiary',
						'BookingDate' => '15/07/2015 11:00:00',
						'BookingId' => '355177',
						'BookingTime' => '11:00',
						'Duration' => '00:15',
						'DurationInSeconds' => '900',
						'FailureDescription' => '',
						'Status' => 'Yes',
						'Value' => '172.5'
					)
				)
			)
		);
	}

/**
 * Sample data from API for testing
 *
 * @return array
 */
	protected function _apiGetAvailableDiarySlotsResponse() {
		$json = file_get_contents(CakePlugin::path('BuzzDiaryAccounts') . 'Test' . DS . 'Fixture' . DS . 'GetAvailableDiarySlots.json');
		return ['DiaryApi' => json_decode($json, true)];
	}

}
