<?php
App::uses('CakeEventListener', 'Event');
App::uses('CustomEmail', 'Lib');
App::uses('PurchaseTrait', 'BuzzPurchase.Lib/Traits');

class AccountCreditListener implements CakeEventListener {

	use PurchaseTrait;

	public function implementedEvents() {
		return array(
			'Model.AccountCredit.completed' => 'sendCreditConfirmationEmail',
			'Model.AccountCredit.creditAdded' => 'sendPaymentRequestPaidConfirmationEmail'
		);
	}

/**
 * Send credit confirmation email.
 *
 * @param CakeEvent $Event
 * @return void
 */
	public function sendCreditConfirmationEmail(CakeEvent $Event) {
		$id = $Event->data['id'];

		$data = ClassRegistry::init('BuzzDiaryAccounts.AccountCredit')->find(
			'first',
			array(
				'contain' => array(
					'Account'
				),
				'conditions' => array(
					'AccountCredit.id' => $id
				)
			)
		);

		// Send payment request email
		$Email = ClassRegistry::init('BuzzEmails.Email');

		// Calculate the tax.
		$taxPercent = Configure::read('BuzzPurchase.taxPercent');
		$tax = empty($taxPercent) ? 0 : $this->calculateTax($data['AccountCredit']['amount'], $taxPercent);

		$email = $Email->generateEmailData(
			'BuzzDiaryAccounts.credit_confirmation_email',
			[
				'fullName' => $data['Account']['full_name'],
				'firstName' => $data['Account']['first_name'],
				'lastName' => $data['Account']['last_name'],
				'amount' => CakeNumber::currency($data['AccountCredit']['amount']),
				'salesRef' => $data['AccountCredit']['sales_ref'],
				'tax' => CakeNumber::currency($tax)
			]
		);

		if ($email !== false) {
			$Email->queueEmail(
				$email['Email']['subject'],
				$email['Email']['content'],
				array($data['Account']['email'] => $data['Account']['full_name']),
				$email['Email']['from']
			);
		}

		return;
	}

/**
 * Send credit confirmation email after credit is added via a payment request.
 *
 * @param CakeEvent $Event
 * @return void
 */
	public function sendPaymentRequestPaidConfirmationEmail(CakeEvent $Event) {
		$id = $Event->data['id'];

		$data = ClassRegistry::init('BuzzDiaryAccounts.AccountCredit')->find(
			'first',
			array(
				'contain' => array(
					'Account',
					'AccountPaymentRequest'
				),
				'conditions' => array(
					'AccountCredit.id' => $id
				)
			)
		);

		// Calculate the tax.
		$taxPercent = Configure::read('BuzzPurchase.taxPercent');
		$tax = empty($taxPercent) ? 0 : $this->calculateTax($data['AccountCredit']['amount'], $taxPercent);

		$vars = [
			'fullName' => $data['Account']['full_name'],
			'firstName' => $data['Account']['first_name'],
			'lastName' => $data['Account']['last_name'],
			'amount' => CakeNumber::currency($data['AccountCredit']['amount']),
			'salesRef' => $data['AccountCredit']['sales_ref'],
			'payerName' => $data['AccountPaymentRequest']['name'],
			'payerEmail' => $data['AccountPaymentRequest']['email_address'],
			'requestRef' => $data['AccountPaymentRequest']['reference'],
			'tax' => CakeNumber::currency($tax)
		];

		$Email = ClassRegistry::init('BuzzEmails.Email');

		// Send email to account holder
		$email = $Email->generateEmailData(
			'BuzzDiaryAccounts.third_party_credit_confirmation_email',
			$vars
		);

		if ($email !== false) {
			$Email->queueEmail(
				$email['Email']['subject'],
				$email['Email']['content'],
				array($data['Account']['email'] => $data['Account']['full_name']),
				$email['Email']['from']
			);
		}

		// Send email to payer
		$email = $Email->generateEmailData(
			'BuzzDiaryAccounts.payment_request_paid_email',
			$vars
		);

		if ($email !== false) {
			$Email->queueEmail(
				$email['Email']['subject'],
				$email['Email']['content'],
				array($data['AccountPaymentRequest']['email_address'] => $data['AccountPaymentRequest']['name']),
				$email['Email']['from']
			);
		}

		return;
	}

}
