<?php

App::uses('AppController', 'Controller');

class BuzzDiaryAccountsAppController extends AppController {

/**
 * Define actions that will require account authentication.
 *
 * @var array
 */
	public $requiresAccountAuth = [];

/**
 * Common BuzzDiaryAccounts before filter logic.
 *
 * @return void
 */
	public function beforeFilter() {
		if (
			in_array($this->request->params['action'], ['login', 'logout', 'register', 'activate', 'forgotten_password'])
			|| in_array($this->request->params['action'], $this->requiresAccountAuth)
		) {
			AuthComponent::$sessionKey = 'Auth.Account';
			$this->Auth->loginAction = $this->_getLoginAction();
			$this->Auth->logoutRedirect = '/';

			$this->Auth->authenticate = array(
				'Form' => array(
					'userModel' => 'BuzzDiaryAccounts.Account',
					'fields' => array('username' => 'email'),
					'scope' => array(
						'Account.is_active' => true,
						'Account.api_reference <>' => null
					)
				)
			);

			// Make sure we allow the register action (it needs to be in
			// here to associate it with this auth instance).
			$this->Auth->allow(['register', 'activate', 'forgotten_password']);

			$this->set('accountUser', $this->Session->read('Auth'));

		} elseif (!$this->request->prefix == 'admin') {
			$this->Auth->allow();

		}

		parent::beforeFilter();

		return;
	}

/**
 * Returns the login action for the accounts section.
 *
 * @return array
 */
	protected function _getLoginAction() {
		$loginAction = Configure::read('BuzzDiaryAccounts.login_action');
		if (!is_array($loginAction)) {
			$loginAction = ['controller' => 'accounts', 'action' => 'login', 'plugin' => 'buzz_diary_accounts'];
		}
		return $loginAction;
	}

	protected function _loadPageContent() {
		if (Configure::check('BuzzDiaryAccounts.accounts_page_id') === true) {
			$this->assignPage(
				Configure::read('BuzzDiaryAccounts.accounts_page_id'),
				'pageContent'
			);
		}

		$this->loadModel('BuzzSites.Site');
		$sites = $this->Site->getAll();
		$this->set(compact('sites'));

		return;
	}

}
