<?php
class BuzzDiaryAccountsEmails extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'BuzzDiaryAccounts_emails';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
		),
		'down' => array(
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		if ($direction === 'up') {
			$EmailGroup = ClassRegistry::init('BuzzEmails.EmailGroup');
			$data = array(
				'name' => 'Diary Accounts'
			);
			$EmailGroup->save($data);
			$data = array(
				array(
					'name' => 'Account Registration Confirmation',
					'system_name' => 'BuzzDiaryAccounts.registration_email',
					'email_group_id' => $EmailGroup->id,
					'subject' => 'Account Registration',
					'content' => '<p>Hi {firstName},</p><p>Thank you for registering for an account. Click on the link below to activate your account:-</p><p><a href="{activationUrl}">{activationUrl}</a></p>',
					'required_tokens' => '["activationUrl"]',
					'optional_tokens' => '["fullName","firstName","lastName"]'
				),
				array(
					'name' => 'Account Activation Confirmation',
					'system_name' => 'BuzzDiaryAccounts.activated_email',
					'email_group_id' => $EmailGroup->id,
					'subject' => 'Account Activated',
					'content' => '<p>Hi {firstName},</p><p>Your account has been activated.</p><p><a href="{url}">{url}</a></p>',
					'required_tokens' => '',
					'optional_tokens' => '["url","fullName","firstName","lastName"]'
				),
				array(
					'name' => 'Account Password Reset',
					'system_name' => 'BuzzDiaryAccounts.password_reset_email',
					'email_group_id' => $EmailGroup->id,
					'subject' => 'Password Reset',
					'content' => '<p>Hi {firstName},</p><p>To reset your password click on the link below:-</p><p><a href="{url}">{url}</a></p>',
					'required_tokens' => '["url"]',
					'optional_tokens' => '["fullName","firstName","lastName"]'
				),
				array(
					'name' => 'Diary Booking Confirmation',
					'system_name' => 'BuzzDiaryAccounts.booking_confirmation_email',
					'email_group_id' => $EmailGroup->id,
					'subject' => 'Booking Confirmation',
					'content' => '<p>Hi {firstName},</p><p>Your sales reference is: <strong>{salesRef}</strong></p><p>Your booking is for {date} at {time}.</p>',
					'required_tokens' => '["salesRef","date","time"]',
					'optional_tokens' => '["fullName","firstName","lastName","duration"]'
				),
				array(
					'name' => 'Diary Booking Cancellation',
					'system_name' => 'BuzzDiaryAccounts.booking_cancellation_email',
					'email_group_id' => $EmailGroup->id,
					'subject' => 'Booking Cancelled',
					'content' => '<p>Hi {firstName},</p><p>We have cancelled your booking for you. Your cancellation reference is: <strong>{ref}</strong></p>',
					'required_tokens' => '["ref"]',
					'optional_tokens' => '["fullName","firstName","lastName"]'
				),
				array(
					'name' => 'Account Credit Confirmation',
					'system_name' => 'BuzzDiaryAccounts.credit_confirmation_email',
					'email_group_id' => $EmailGroup->id,
					'subject' => 'Your Account has been Credited',
					'content' => '<p>Hi {firstName},</p><p>Your sales reference is: <strong>{salesRef}</strong></p><p>We have added {amount} to your account.</p>',
					'required_tokens' => '["amount","salesRef"]',
					'optional_tokens' => '["fullName","firstName","lastName","tax"]'
				),
				array(
					'name' => 'Account Credit Confirmation (Third Party)',
					'system_name' => 'BuzzDiaryAccounts.third_party_credit_confirmation_email',
					'email_group_id' => $EmailGroup->id,
					'subject' => 'Your Account has been Credited',
					'content' => '<p>Hi {firstName},</p><p>{payerName} has added {amount} ({requestRef}) to your account.</p><p>Your reference is: <strong>{salesRef}</strong></p>',
					'required_tokens' => '["amount","salesRef","payerName","requestRef"]',
					'optional_tokens' => '["fullName","firstName","lastName","payerEmail"]'
				),
				array(
					'name' => 'Payment Request',
					'system_name' => 'BuzzDiaryAccounts.payment_request_email',
					'email_group_id' => $EmailGroup->id,
					'subject' => 'Payment Request',
					'content' => '<p>Hi {name},</p><p>{requester} has requested a payment of {amount} from you.</p><p>Your payment request reference is: {ref}</p><p>{description}</p><p><a href="{url}">Click here to pay now</a></p>',
					'required_tokens' => '["ref","amount","name","description","requester","url"]',
					'optional_tokens' => ''
				),
				array(
					'name' => 'Payment Request Confirmation',
					'system_name' => 'BuzzDiaryAccounts.payment_request_paid_email',
					'email_group_id' => $EmailGroup->id,
					'subject' => 'Payment Received',
					'content' => '<p>Hi {payerName},</p><p>Your payment of {amount} for {fullName} ({requestRef}) has been received.</p><p>Your sales reference is: <strong>{salesRef}</strong></p>',
					'required_tokens' => '["amount","salesRef","payerName","requestRef"]',
					'optional_tokens' => '["fullName","firstName","lastName","payerEmail"]'
				),
			);
			ClassRegistry::init('BuzzEmails.Email')->saveMany($data);
		}
		return true;
	}
}
