<?php

class CustomerAddressTest extends CakeTestCase {

	public function setUp() {
		parent::setUp();
		$this->CustomerAddress = ClassRegistry::init('BuzzCustomers.CustomerAddress');
	}

	public function testPostcodeValidation() {
		// Test a valid UK postcode.
		$this->CustomerAddress->data['CustomerAddress']['country_id'] = 225;
		$result = $this->CustomerAddress->validatePostcode(['S3 7BH']);
		$this->assertTrue($result);

		// Test an empty UK postcode.
		$this->CustomerAddress->data['CustomerAddress']['country_id'] = 225;
		$result = $this->CustomerAddress->validatePostcode(['']);
		$this->assertFalse($result);

		// Test an invalid UK postcode
		$this->CustomerAddress->data['CustomerAddress']['country_id'] = 225;
		$result = $this->CustomerAddress->validatePostcode(['S37BH']);
		$this->assertFalse($result);

		// Test an empty Irish postcode.
		$this->CustomerAddress->data['CustomerAddress']['country_id'] = 103;
		$result = $this->CustomerAddress->validatePostcode(['']);
		$this->assertTrue($result);

		return;
	}

	public function testUsStateValidation() {
		// Test a US state has been supplied for an American address.
		$this->CustomerAddress->data['CustomerAddress']['country_id'] = 226;
		$result = $this->CustomerAddress->validateRequiredByCountry(['us_state_id' => 1], 226);
		$this->assertTrue($result);

		$this->CustomerAddress->data['CustomerAddress']['country_id'] = 226;
		$result = $this->CustomerAddress->validateRequiredByCountry(['us_state_id' => null], 226);
		$this->assertFalse($result);

		$this->CustomerAddress->data['CustomerAddress']['country_id'] = 225;
		$result = $this->CustomerAddress->validateRequiredByCountry(['us_state_id' => null], 226);
		$this->assertTrue($result);

		return;
	}

	public function testGenerateAddressArray() {
		$result = $this->CustomerAddress->generateAddressArray(
			array(
				'address_line_1' => 'Evoluted',
				'address_line_2' => '35 Lambert Street',
				'city' => 'Sheffield',
				'country_id' => 225,
				'postcode' => 'S3 7BH',
				'Country' => array(
					'name' => 'United Kingdom'
				),
				'UsState' => array(
					'name' => null
				)
			)
		);
		$expected = array(
			'address_line_1' => 'Evoluted',
			'address_line_2' => '35 Lambert Street',
			'address_line_3' => 'Sheffield',
			'address_line_4' => 'United Kingdom',
			'postcode' => 'S3 7BH'
		);
		$this->assertEquals($expected, $result);

		$result = $this->CustomerAddress->generateAddressArray(
			array(
				'address_line_1' => 'Department of State',
				'address_line_2' => '2050 Bamako Place',
				'city' => 'Washington',
				'country_id' => 226,
				'postcode' => '20521-2050',
				'Country' => array(
					'name' => 'United States'
				),
				'UsState' => array(
					'name' => 'DC'
				)
			)
		);
		$expected = array(
			'address_line_1' => 'Department of State',
			'address_line_2' => '2050 Bamako Place',
			'address_line_3' => 'Washington, DC',
			'address_line_4' => 'United States',
			'postcode' => '20521-2050'
		);
		$this->assertEquals($expected, $result);

		return;
	}

}
