<?php
class BuzzCustomersSwedishCountryNames extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'BuzzCustomers_Swedish_country_names';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
		),
		'down' => array(
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		if ($direction === 'up') {
			$this->_populateCountries();
		} else {
			ClassRegistry::init('BuzzTranslate.Translation')->deleteAll(['model' => 'Country', 'locale' => 'swe']);
		}
		return true;
	}

	protected function _populateCountries() {
		// Spanish country names translated via Google Translate (we need to
		// map these onto the existing English countries).
		$countries = <<<EOT
Afghanistan
Albanien
Algeriet
Amerikanska Samoa
Andorra
Angola
Anguilla
Antarktis
Antigua och Barbuda
Argentina
Armenien
Aruba
Australien
Österrike
Azerbajdzjan
Bahamas
Bahrain
Bangladesh
Barbados
Vitryssland
Belgien
Belize
Benin
Bermuda
Bhutan
Bolivia
Bosnien och Hercegovina
Botswana
Bouvet Island
Brasilien
Brittiska Indiska Oceanen
Brunei
Bulgarien
Burkina Faso
Burundi
Kambodja
Kamerun
Kanada
Cap Verde
Caymanöarna
Centralafrikanska republiken
Tchad
Chile
Kina
Julön
Cocos (Keeling) Islands
Colombia
Komorerna
Kongo
Kongo, Demokratiska republiken
Cooköarna
Costa rica
Elfenbenskusten
Kroatien
Kuba
Cypern
Tjeckien
Danmark
Djibouti
Dominica
Dominikanska republiken
Ecuador
Egypten
El Salvador
Ekvatorialguinea
Eritrea
Estland
Etiopien
Falklandsöarna (Malvinas)
Färöarna
Fiji
Finland
Frankrike
Franska Guyana
Franska Polynesien
Franska Sydterritorierna
Gabon
Gambia
Georgien
Tyskland
Ghana
Gibraltar
Grekland
Grönland
Grenada
Guadeloupe
Guam
Guatemala
Guinea
GUINEA-BISSAU
Guyana
Haiti
Heardön och Mcdonaldöarna
Heliga stolen (Vatikanstaten)
Honduras
Hong Kong
Ungern
Island
Indien
Indonesien
Iran, Islamiska republiken
Irak
Irland
Israel
Italien
Jamaica
Japan
Jordanien
Kazakstan
Kenya
Kiribati
Korea, Demokratiska folkrepubliken
Korea, Republiken av
Kuwait
Kirgizistan
Laos Demokratiska folkrepubliken
Lettland
Libanon
Lesotho
Liberia
Libyen
Liechtenstein
Litauen
Luxemburg
Macao
Makedonien, fd jugoslaviska republiken
Madagaskar
Malawi
Malaysia
Maldiverna
Mali
Malta
Marshallöarna
Martinique
Mauretanien
Mauritius
Mayotte
Mexico
Mikronesien, federationen
Moldavien
Monaco
Mongoliet
Montserrat
Marocko
Moçambique
Myanmar
Namibia
Nauru
Nepal
Nederländerna
Nederländska Antillerna
Nya Kaledonien
Nya Zeeland
Nicaragua
Niger
Nigeria
Niue
Norfolk Island
Nordmarianerna
Norge
Oman
Pakistan
Palau
Det Ockuperade Palestinska Territoriet
Panama
Papua Nya Guinea
Paraguay
Peru
Filippinerna
Pitcairn
Polen
Portugal
Puerto Rico
Qatar
Återförening
Rumänien
Ryska Federationen
Rwanda
Saint Helena
Saint Kitts och Nevis
Saint Lucia
Saint Pierre och Miquelon
Saint Vincent och Grenadinerna
Samoa
San Marino
Sao Tomé och Príncipe
Saudiarabien
Senegal
Serbien och Montenegro
Seychellerna
Sierra Leone
Singapore
Slovakien
Slovenien
Salomonöarna
Somalia
Sydafrika
Sydgeorgien och Sydsandwichöarna
Spanien
Sri Lanka
Sudan
Surinam
Svalbard och Jan Mayen
Swaziland
Sverige
Schweiz
Syriska Arabrepubliken
Taiwan, provinsen i Kina
Tadzjikistan
Tanzania för
Thailand
Timor-Leste
Togo
Tokelau
Tonga
Trinidad och Tobago
Tunisien
Kalkon
Turkmenistan
Turks- och Caicosöarna
Tuvalu
Uganda
Ukraina
Förenade arabemiraten
Storbritannien
Förenta staterna
USA: s avlägset belägna öar
Uruguay
Uzbekistan
Vanuatu
Venezuela
Viet Nam
Jungfruöarna, Brittiska
Jungfruöarna, USA
Wallis och Futuna
Västra Sahara
Jemen
Zambia
Zimbabwe
EOT;
		$data = [];
		$countries = explode("\n", $countries);
		foreach ($countries as $key => $val) {
			$data[] = [
				'model' => 'Country',
				'foreign_id' => $key + 1,
				'locale' => 'swe',
				'content' => '{"name":"' . $val . '"}'
			];
		}
		return ClassRegistry::init('BuzzTranslate.Translation')->saveMany($data);
	}
}
