<?php
class BuzzCustomersSpanishCountryNames extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'BuzzCustomers_spanish_country_names';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(),
		'down' => array(),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		if ($direction === 'up') {
			$this->_populateCountries();
		} else {
			ClassRegistry::init('BuzzTranslate.Translation')->deleteAll(['model' => 'Country', 'locale' => 'spa']);
		}
		return true;
	}

	protected function _populateCountries() {
		// Spanish country names translated via Google Translate (we need to
		// map these onto the existing English countries).
		$countries = <<<EOT
Afganistán
Albania
Argelia
Samoa Americana
Andorra
Angola
Anguila
Antártida
Antigua y Barbuda
Argentina
Armenia
Aruba
Australia
Austria
Azerbaiyán
Bahamas
Bahrein
Bangladesh
Barbados
Bielorrusia
Bélgica
Belice
Benin
Bermuda
Bhután
Bolivia
Bosnia y Herzegovina
Botswana
Isla Bouvet
Brasil
Territorio Británico del Océano Índico
Brunei Darussalam
Bulgaria
Burkina Faso
Burundi
Camboya
Camerún
Canadá
Cabo Verde
Islas Caimán
República Centroafricana
Chad
Chile
China
Isla de Navidad
Cocos (Keeling)
Colombia
Comoras
Congo
Congo, la República Democrática del
Islas Cook
Costa Rica
Costa de Marfil
Croacia
Cuba
Chipre
República Checa
Dinamarca
Djibouti
Dominica
República Dominicana
Ecuador
Egipto
El Salvador
Guinea Ecuatorial
Eritrea
Estonia
Etiopía
Islas Malvinas (Falkland)
Islas Faroe
Fiji
Finlandia
Francia
Guiana francés
Polinesia francés
Territorios Franceses del Sur
Gabón
Gambia
Georgia
Alemania
Ghana
Gibraltar
Grecia
Groenlandia
Granada
Guadalupe
Guam
Guatemala
Guinea
Guinea-Bissau
Guayana
Haití
Isla Islas Heard y McDonald
Santa Sede (Ciudad del Vaticano)
Honduras
Hong Kong
Hungría
Islandia
India
Indonesia
Irán, República Islámica del
Irak
Irlanda
Israel
Italia
Jamaica
Japón
Jordania
Kazajstán
Kenia
Kiribati
Corea, Popular Democrática de 'República de
Corea, Republica de
Kuwait
Kirguistán
República Democrática Popular Lao
Letonia
Líbano
Lesoto
Liberia
Jamahiriya Árabe Libia
Liechtenstein
Lituania
Luxemburgo
Macao
Macedonia, la ex República Yugoslava de
Madagascar
Malawi
Malasia
Maldivas
Malí
Malta
Islas Marshall
Martinica
Mauritania
Mauricio
Mayotte
México
Micronesia, Estados Federados de
Moldova, República de
Mónaco
Mongolia
Montserrat
Marruecos
Mozambique
Myanmar
Namibia
Nauru
Nepal
Países Bajos
Antillas Holandesas
Nueva Caledonia
Nueva Zelanda
Nicaragua
Níger
Nigeria
Niue
Isla Norfolk
Islas Marianas del Norte
Noruega
Omán
Pakistán
Palau
Palestina, Territorio Ocupado
Panamá
Papúa Nueva Guinea
Paraguay
Perú
Filipinas
Pitcairn
Polonia
Portugal
Puerto Rico
Katar
Reunión
Rumania
Federación Rusa
Ruanda
Santa Helena
San Cristóbal y Nieves
Santa Lucía
San Pedro y Miquelón
San Vicente y las Granadinas
Samoa
San Marino
Santo Tomé y Príncipe
Arabia Saudita
Senegal
Serbia y Montenegro
Seychelles
Sierra Leona
Singapur
Eslovaquia
Eslovenia
Islas Salomón
Somalia
Sudáfrica
Georgia del Sur y las Islas Sandwich del Sur
España
Sri Lanka
Sudán
Suriname
Svalbard y Jan Mayen
Swazilandia
Suecia
Suiza
República Árabe Siria
Taiwán, Provincia de China
Tayikistán
Tanzania, República Unida de
Tailandia
Timor-Leste
Ir
Tokelau
Tonga
Trinidad y Tobago
Túnez
Pavo
Turkmenistán
Islas Turcas y Caicos
Tuvalu
Uganda
Ucrania
Emiratos Árabes Unidos
Reino Unido
Estados Unidos
Estados Unidos Islas menores alejadas de
Uruguay
Uzbekistán
Vanuatu
Venezuela
Viet Nam
Islas Vírgenes Británicas
Islas Vírgenes de Estados Unidos
Wallis y Futuna
Sahara Occidental
Yemen
Zambia
Zimbabue
EOT;
		$data = [];
		$countries = explode("\n", $countries);
		foreach ($countries as $key => $val) {
			$data[] = [
				'model' => 'Country',
				'foreign_id' => $key + 1,
				'locale' => 'spa',
				'content' => '{"name":"' . $val . '"}'
			];
		}
		return ClassRegistry::init('BuzzTranslate.Translation')->saveMany($data);
	}

}
