<?php
class BuzzCustomersSetupTables extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'BuzzCustomers_setup_tables';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'create_table' => array(
				'countries' => array(
					'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false, 'key' => 'primary'),
					'name' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 45, 'collate' => 'latin1_swedish_ci', 'charset' => 'latin1'),
					'iso2' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 2, 'collate' => 'latin1_swedish_ci', 'charset' => 'latin1'),
					'is_active' => array('type' => 'boolean', 'null' => false, 'default' => '1'),
					'sequence' => array('type' => 'integer', 'null' => false, 'default' => '0', 'unsigned' => false),
					'indexes' => array(
						'PRIMARY' => array('column' => 'id', 'unique' => 1),
					),
					'tableParameters' => array('charset' => 'utf8', 'collate' => 'utf8_unicode_ci', 'engine' => 'InnoDB'),
				),
				'customer_addresses' => array(
					'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false, 'key' => 'primary'),
					'first_name' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 45, 'collate' => 'latin1_swedish_ci', 'charset' => 'latin1'),
					'last_name' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 45, 'collate' => 'latin1_swedish_ci', 'charset' => 'latin1'),
					'address_line_1' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 45, 'collate' => 'latin1_swedish_ci', 'charset' => 'latin1'),
					'address_line_2' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 45, 'collate' => 'latin1_swedish_ci', 'charset' => 'latin1'),
					'city' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 45, 'collate' => 'latin1_swedish_ci', 'charset' => 'latin1'),
					'county' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 45, 'collate' => 'latin1_swedish_ci', 'charset' => 'latin1'),
					'us_state_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false, 'key' => 'index'),
					'country_id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false, 'key' => 'index'),
					'postcode' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 20, 'collate' => 'latin1_swedish_ci', 'charset' => 'latin1'),
					'telephone' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 20, 'collate' => 'latin1_swedish_ci', 'charset' => 'latin1'),
					'email' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 254, 'collate' => 'latin1_swedish_ci', 'charset' => 'latin1'),
					'created' => array('type' => 'datetime', 'null' => true, 'default' => null),
					'modified' => array('type' => 'datetime', 'null' => true, 'default' => null),
					'indexes' => array(
						'PRIMARY' => array('column' => 'id', 'unique' => 1),
						'fk_customer_addresses_countries1' => array('column' => 'country_id', 'unique' => 0),
						'fk_customer_addresses_us_states1' => array('column' => 'us_state_id', 'unique' => 0),
					),
					'tableParameters' => array('charset' => 'utf8', 'collate' => 'utf8_unicode_ci', 'engine' => 'InnoDB'),
				),
				'us_states' => array(
					'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false, 'key' => 'primary'),
					'name' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 45, 'collate' => 'latin1_swedish_ci', 'charset' => 'latin1'),
					'code' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 2, 'collate' => 'latin1_swedish_ci', 'charset' => 'latin1'),
					'is_active' => array('type' => 'boolean', 'null' => false, 'default' => '1'),
					'sequence' => array('type' => 'integer', 'null' => false, 'default' => '0', 'unsigned' => false),
					'indexes' => array(
						'PRIMARY' => array('column' => 'id', 'unique' => 1),
					),
					'tableParameters' => array('charset' => 'utf8', 'collate' => 'utf8_unicode_ci', 'engine' => 'InnoDB'),
				),
			),
		),
		'down' => array(
			'drop_table' => array(
				'countries', 'customer_addresses', 'us_states'
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		if ($direction === 'up') {
			$this->_populateCountries();
			$this->_populateUsStates();
		}
		return true;
	}

	protected function _populateCountries() {
		$data = array(
			array(
				'Country' => array(
					'id' => '1',
					'name' => 'Afghanistan',
					'iso2' => 'AF',
					'is_active' => true,
					'sequence' => '1',
				)
			),
			array(
				'Country' => array(
					'id' => '2',
					'name' => 'Albania',
					'iso2' => 'AL',
					'is_active' => true,
					'sequence' => '2'
				)
			),
			array(
				'Country' => array(
					'id' => '3',
					'name' => 'Algeria',
					'iso2' => 'DZ',
					'is_active' => true,
					'sequence' => '3'
				)
			),
			array(
				'Country' => array(
					'id' => '4',
					'name' => 'American Samoa',
					'iso2' => 'AS',
					'is_active' => true,
					'sequence' => '4'
				)
			),
			array(
				'Country' => array(
					'id' => '5',
					'name' => 'Andorra',
					'iso2' => 'AD',
					'is_active' => true,
					'sequence' => '5'
				)
			),
			array(
				'Country' => array(
					'id' => '6',
					'name' => 'Angola',
					'iso2' => 'AO',
					'is_active' => true,
					'sequence' => '6'
				)
			),
			array(
				'Country' => array(
					'id' => '7',
					'name' => 'Anguilla',
					'iso2' => 'AI',
					'is_active' => true,
					'sequence' => '7'
				)
			),
			array(
				'Country' => array(
					'id' => '8',
					'name' => 'Antarctica',
					'iso2' => 'AQ',
					'is_active' => true,
					'sequence' => '8'
				)
			),
			array(
				'Country' => array(
					'id' => '9',
					'name' => 'Antigua and Barbuda',
					'iso2' => 'AG',
					'is_active' => true,
					'sequence' => '9'
				)
			),
			array(
				'Country' => array(
					'id' => '10',
					'name' => 'Argentina',
					'iso2' => 'AR',
					'is_active' => true,
					'sequence' => '10'
				)
			),
			array(
				'Country' => array(
					'id' => '11',
					'name' => 'Armenia',
					'iso2' => 'AM',
					'is_active' => true,
					'sequence' => '11'
				)
			),
			array(
				'Country' => array(
					'id' => '12',
					'name' => 'Aruba',
					'iso2' => 'AW',
					'is_active' => true,
					'sequence' => '12'
				)
			),
			array(
				'Country' => array(
					'id' => '13',
					'name' => 'Australia',
					'iso2' => 'AU',
					'is_active' => true,
					'sequence' => '13'
				)
			),
			array(
				'Country' => array(
					'id' => '14',
					'name' => 'Austria',
					'iso2' => 'AT',
					'is_active' => true,
					'sequence' => '14'
				)
			),
			array(
				'Country' => array(
					'id' => '15',
					'name' => 'Azerbaijan',
					'iso2' => 'AZ',
					'is_active' => true,
					'sequence' => '15'
				)
			),
			array(
				'Country' => array(
					'id' => '16',
					'name' => 'Bahamas',
					'iso2' => 'BS',
					'is_active' => true,
					'sequence' => '16'
				)
			),
			array(
				'Country' => array(
					'id' => '17',
					'name' => 'Bahrain',
					'iso2' => 'BH',
					'is_active' => true,
					'sequence' => '17'
				)
			),
			array(
				'Country' => array(
					'id' => '18',
					'name' => 'Bangladesh',
					'iso2' => 'BD',
					'is_active' => true,
					'sequence' => '18'
				)
			),
			array(
				'Country' => array(
					'id' => '19',
					'name' => 'Barbados',
					'iso2' => 'BB',
					'is_active' => true,
					'sequence' => '19'
				)
			),
			array(
				'Country' => array(
					'id' => '20',
					'name' => 'Belarus',
					'iso2' => 'BY',
					'is_active' => true,
					'sequence' => '20'
				)
			),
			array(
				'Country' => array(
					'id' => '21',
					'name' => 'Belgium',
					'iso2' => 'BE',
					'is_active' => true,
					'sequence' => '21'
				)
			),
			array(
				'Country' => array(
					'id' => '22',
					'name' => 'Belize',
					'iso2' => 'BZ',
					'is_active' => true,
					'sequence' => '22'
				)
			),
			array(
				'Country' => array(
					'id' => '23',
					'name' => 'Benin',
					'iso2' => 'BJ',
					'is_active' => true,
					'sequence' => '23'
				)
			),
			array(
				'Country' => array(
					'id' => '24',
					'name' => 'Bermuda',
					'iso2' => 'BM',
					'is_active' => true,
					'sequence' => '24'
				)
			),
			array(
				'Country' => array(
					'id' => '25',
					'name' => 'Bhutan',
					'iso2' => 'BT',
					'is_active' => true,
					'sequence' => '25'
				)
			),
			array(
				'Country' => array(
					'id' => '26',
					'name' => 'Bolivia',
					'iso2' => 'BO',
					'is_active' => true,
					'sequence' => '26'
				)
			),
			array(
				'Country' => array(
					'id' => '27',
					'name' => 'Bosnia and Herzegovina',
					'iso2' => 'BA',
					'is_active' => true,
					'sequence' => '27'
				)
			),
			array(
				'Country' => array(
					'id' => '28',
					'name' => 'Botswana',
					'iso2' => 'BW',
					'is_active' => true,
					'sequence' => '28'
				)
			),
			array(
				'Country' => array(
					'id' => '29',
					'name' => 'Bouvet Island',
					'iso2' => 'BV',
					'is_active' => true,
					'sequence' => '29'
				)
			),
			array(
				'Country' => array(
					'id' => '30',
					'name' => 'Brazil',
					'iso2' => 'BR',
					'is_active' => true,
					'sequence' => '30'
				)
			),
			array(
				'Country' => array(
					'id' => '31',
					'name' => 'British Indian Ocean Territory',
					'iso2' => 'IO',
					'is_active' => true,
					'sequence' => '31'
				)
			),
			array(
				'Country' => array(
					'id' => '32',
					'name' => 'Brunei Darussalam',
					'iso2' => 'BN',
					'is_active' => true,
					'sequence' => '32'
				)
			),
			array(
				'Country' => array(
					'id' => '33',
					'name' => 'Bulgaria',
					'iso2' => 'BG',
					'is_active' => true,
					'sequence' => '33'
				)
			),
			array(
				'Country' => array(
					'id' => '34',
					'name' => 'Burkina Faso',
					'iso2' => 'BF',
					'is_active' => true,
					'sequence' => '34'
				)
			),
			array(
				'Country' => array(
					'id' => '35',
					'name' => 'Burundi',
					'iso2' => 'BI',
					'is_active' => true,
					'sequence' => '35'
				)
			),
			array(
				'Country' => array(
					'id' => '36',
					'name' => 'Cambodia',
					'iso2' => 'KH',
					'is_active' => true,
					'sequence' => '36'
				)
			),
			array(
				'Country' => array(
					'id' => '37',
					'name' => 'Cameroon',
					'iso2' => 'CM',
					'is_active' => true,
					'sequence' => '37'
				)
			),
			array(
				'Country' => array(
					'id' => '38',
					'name' => 'Canada',
					'iso2' => 'CA',
					'is_active' => true,
					'sequence' => '38'
				)
			),
			array(
				'Country' => array(
					'id' => '39',
					'name' => 'Cape Verde',
					'iso2' => 'CV',
					'is_active' => true,
					'sequence' => '39'
				)
			),
			array(
				'Country' => array(
					'id' => '40',
					'name' => 'Cayman Islands',
					'iso2' => 'KY',
					'is_active' => true,
					'sequence' => '40'
				)
			),
			array(
				'Country' => array(
					'id' => '41',
					'name' => 'Central African Republic',
					'iso2' => 'CF',
					'is_active' => true,
					'sequence' => '41'
				)
			),
			array(
				'Country' => array(
					'id' => '42',
					'name' => 'Chad',
					'iso2' => 'TD',
					'is_active' => true,
					'sequence' => '42'
				)
			),
			array(
				'Country' => array(
					'id' => '43',
					'name' => 'Chile',
					'iso2' => 'CL',
					'is_active' => true,
					'sequence' => '43'
				)
			),
			array(
				'Country' => array(
					'id' => '44',
					'name' => 'China',
					'iso2' => 'CN',
					'is_active' => true,
					'sequence' => '44'
				)
			),
			array(
				'Country' => array(
					'id' => '45',
					'name' => 'Christmas Island',
					'iso2' => 'CX',
					'is_active' => true,
					'sequence' => '45'
				)
			),
			array(
				'Country' => array(
					'id' => '46',
					'name' => 'Cocos (Keeling) Islands',
					'iso2' => 'CC',
					'is_active' => true,
					'sequence' => '46'
				)
			),
			array(
				'Country' => array(
					'id' => '47',
					'name' => 'Colombia',
					'iso2' => 'CO',
					'is_active' => true,
					'sequence' => '47'
				)
			),
			array(
				'Country' => array(
					'id' => '48',
					'name' => 'Comoros',
					'iso2' => 'KM',
					'is_active' => true,
					'sequence' => '48'
				)
			),
			array(
				'Country' => array(
					'id' => '49',
					'name' => 'Congo',
					'iso2' => 'CG',
					'is_active' => true,
					'sequence' => '49'
				)
			),
			array(
				'Country' => array(
					'id' => '50',
					'name' => 'Congo,  the Democratic Republic of the',
					'iso2' => 'CD',
					'is_active' => true,
					'sequence' => '50'
				)
			),
			array(
				'Country' => array(
					'id' => '51',
					'name' => 'Cook Islands',
					'iso2' => 'CK',
					'is_active' => true,
					'sequence' => '51'
				)
			),
			array(
				'Country' => array(
					'id' => '52',
					'name' => 'Costa Rica',
					'iso2' => 'CR',
					'is_active' => true,
					'sequence' => '52'
				)
			),
			array(
				'Country' => array(
					'id' => '53',
					'name' => 'Cote D\'Ivoire',
					'iso2' => 'CI',
					'is_active' => true,
					'sequence' => '53'
				)
			),
			array(
				'Country' => array(
					'id' => '54',
					'name' => 'Croatia',
					'iso2' => 'HR',
					'is_active' => true,
					'sequence' => '54'
				)
			),
			array(
				'Country' => array(
					'id' => '55',
					'name' => 'Cuba',
					'iso2' => 'CU',
					'is_active' => true,
					'sequence' => '55'
				)
			),
			array(
				'Country' => array(
					'id' => '56',
					'name' => 'Cyprus',
					'iso2' => 'CY',
					'is_active' => true,
					'sequence' => '56'
				)
			),
			array(
				'Country' => array(
					'id' => '57',
					'name' => 'Czech Republic',
					'iso2' => 'CZ',
					'is_active' => true,
					'sequence' => '57'
				)
			),
			array(
				'Country' => array(
					'id' => '58',
					'name' => 'Denmark',
					'iso2' => 'DK',
					'is_active' => true,
					'sequence' => '58'
				)
			),
			array(
				'Country' => array(
					'id' => '59',
					'name' => 'Djibouti',
					'iso2' => 'DJ',
					'is_active' => true,
					'sequence' => '59'
				)
			),
			array(
				'Country' => array(
					'id' => '60',
					'name' => 'Dominica',
					'iso2' => 'DM',
					'is_active' => true,
					'sequence' => '60'
				)
			),
			array(
				'Country' => array(
					'id' => '61',
					'name' => 'Dominican Republic',
					'iso2' => 'DO',
					'is_active' => true,
					'sequence' => '61'
				)
			),
			array(
				'Country' => array(
					'id' => '62',
					'name' => 'Ecuador',
					'iso2' => 'EC',
					'is_active' => true,
					'sequence' => '62'
				)
			),
			array(
				'Country' => array(
					'id' => '63',
					'name' => 'Egypt',
					'iso2' => 'EG',
					'is_active' => true,
					'sequence' => '63'
				)
			),
			array(
				'Country' => array(
					'id' => '64',
					'name' => 'El Salvador',
					'iso2' => 'SV',
					'is_active' => true,
					'sequence' => '64'
				)
			),
			array(
				'Country' => array(
					'id' => '65',
					'name' => 'Equatorial Guinea',
					'iso2' => 'GQ',
					'is_active' => true,
					'sequence' => '65'
				)
			),
			array(
				'Country' => array(
					'id' => '66',
					'name' => 'Eritrea',
					'iso2' => 'ER',
					'is_active' => true,
					'sequence' => '66'
				)
			),
			array(
				'Country' => array(
					'id' => '67',
					'name' => 'Estonia',
					'iso2' => 'EE',
					'is_active' => true,
					'sequence' => '67'
				)
			),
			array(
				'Country' => array(
					'id' => '68',
					'name' => 'Ethiopia',
					'iso2' => 'ET',
					'is_active' => true,
					'sequence' => '68'
				)
			),
			array(
				'Country' => array(
					'id' => '69',
					'name' => 'Falkland Islands (Malvinas)',
					'iso2' => 'FK',
					'is_active' => true,
					'sequence' => '69'
				)
			),
			array(
				'Country' => array(
					'id' => '70',
					'name' => 'Faroe Islands',
					'iso2' => 'FO',
					'is_active' => true,
					'sequence' => '70'
				)
			),
			array(
				'Country' => array(
					'id' => '71',
					'name' => 'Fiji',
					'iso2' => 'FJ',
					'is_active' => true,
					'sequence' => '71'
				)
			),
			array(
				'Country' => array(
					'id' => '72',
					'name' => 'Finland',
					'iso2' => 'FI',
					'is_active' => true,
					'sequence' => '72'
				)
			),
			array(
				'Country' => array(
					'id' => '73',
					'name' => 'France',
					'iso2' => 'FR',
					'is_active' => true,
					'sequence' => '73'
				)
			),
			array(
				'Country' => array(
					'id' => '74',
					'name' => 'French Guiana',
					'iso2' => 'GF',
					'is_active' => true,
					'sequence' => '74'
				)
			),
			array(
				'Country' => array(
					'id' => '75',
					'name' => 'French Polynesia',
					'iso2' => 'PF',
					'is_active' => true,
					'sequence' => '75'
				)
			),
			array(
				'Country' => array(
					'id' => '76',
					'name' => 'French Southern Territories',
					'iso2' => 'TF',
					'is_active' => true,
					'sequence' => '76'
				)
			),
			array(
				'Country' => array(
					'id' => '77',
					'name' => 'Gabon',
					'iso2' => 'GA',
					'is_active' => true,
					'sequence' => '77'
				)
			),
			array(
				'Country' => array(
					'id' => '78',
					'name' => 'Gambia',
					'iso2' => 'GM',
					'is_active' => true,
					'sequence' => '78'
				)
			),
			array(
				'Country' => array(
					'id' => '79',
					'name' => 'Georgia',
					'iso2' => 'GE',
					'is_active' => true,
					'sequence' => '79'
				)
			),
			array(
				'Country' => array(
					'id' => '80',
					'name' => 'Germany',
					'iso2' => 'DE',
					'is_active' => true,
					'sequence' => '80'
				)
			),
			array(
				'Country' => array(
					'id' => '81',
					'name' => 'Ghana',
					'iso2' => 'GH',
					'is_active' => true,
					'sequence' => '81'
				)
			),
			array(
				'Country' => array(
					'id' => '82',
					'name' => 'Gibraltar',
					'iso2' => 'GI',
					'is_active' => true,
					'sequence' => '82'
				)
			),
			array(
				'Country' => array(
					'id' => '83',
					'name' => 'Greece',
					'iso2' => 'GR',
					'is_active' => true,
					'sequence' => '83'
				)
			),
			array(
				'Country' => array(
					'id' => '84',
					'name' => 'Greenland',
					'iso2' => 'GL',
					'is_active' => true,
					'sequence' => '84'
				)
			),
			array(
				'Country' => array(
					'id' => '85',
					'name' => 'Grenada',
					'iso2' => 'GD',
					'is_active' => true,
					'sequence' => '85'
				)
			),
			array(
				'Country' => array(
					'id' => '86',
					'name' => 'Guadeloupe',
					'iso2' => 'GP',
					'is_active' => true,
					'sequence' => '86'
				)
			),
			array(
				'Country' => array(
					'id' => '87',
					'name' => 'Guam',
					'iso2' => 'GU',
					'is_active' => true,
					'sequence' => '87'
				)
			),
			array(
				'Country' => array(
					'id' => '88',
					'name' => 'Guatemala',
					'iso2' => 'GT',
					'is_active' => true,
					'sequence' => '88'
				)
			),
			array(
				'Country' => array(
					'id' => '89',
					'name' => 'Guinea',
					'iso2' => 'GN',
					'is_active' => true,
					'sequence' => '89'
				)
			),
			array(
				'Country' => array(
					'id' => '90',
					'name' => 'Guinea-Bissau',
					'iso2' => 'GW',
					'is_active' => true,
					'sequence' => '90'
				)
			),
			array(
				'Country' => array(
					'id' => '91',
					'name' => 'Guyana',
					'iso2' => 'GY',
					'is_active' => true,
					'sequence' => '91'
				)
			),
			array(
				'Country' => array(
					'id' => '92',
					'name' => 'Haiti',
					'iso2' => 'HT',
					'is_active' => true,
					'sequence' => '92'
				)
			),
			array(
				'Country' => array(
					'id' => '93',
					'name' => 'Heard Island and Mcdonald Islands',
					'iso2' => 'HM',
					'is_active' => true,
					'sequence' => '93'
				)
			),
			array(
				'Country' => array(
					'id' => '94',
					'name' => 'Holy See (Vatican City State)',
					'iso2' => 'VA',
					'is_active' => true,
					'sequence' => '94'
				)
			),
			array(
				'Country' => array(
					'id' => '95',
					'name' => 'Honduras',
					'iso2' => 'HN',
					'is_active' => true,
					'sequence' => '95'
				)
			),
			array(
				'Country' => array(
					'id' => '96',
					'name' => 'Hong Kong',
					'iso2' => 'HK',
					'is_active' => true,
					'sequence' => '96'
				)
			),
			array(
				'Country' => array(
					'id' => '97',
					'name' => 'Hungary',
					'iso2' => 'HU',
					'is_active' => true,
					'sequence' => '97'
				)
			),
			array(
				'Country' => array(
					'id' => '98',
					'name' => 'Iceland',
					'iso2' => 'IS',
					'is_active' => true,
					'sequence' => '98'
				)
			),
			array(
				'Country' => array(
					'id' => '99',
					'name' => 'India',
					'iso2' => 'IN',
					'is_active' => true,
					'sequence' => '99'
				)
			),
			array(
				'Country' => array(
					'id' => '100',
					'name' => 'Indonesia',
					'iso2' => 'ID',
					'is_active' => true,
					'sequence' => '100'
				)
			),
			array(
				'Country' => array(
					'id' => '101',
					'name' => 'Iran,  Islamic Republic of',
					'iso2' => 'IR',
					'is_active' => true,
					'sequence' => '101'
				)
			),
			array(
				'Country' => array(
					'id' => '102',
					'name' => 'Iraq',
					'iso2' => 'IQ',
					'is_active' => true,
					'sequence' => '102'
				)
			),
			array(
				'Country' => array(
					'id' => '103',
					'name' => 'Ireland',
					'iso2' => 'IE',
					'is_active' => true,
					'sequence' => '103'
				)
			),
			array(
				'Country' => array(
					'id' => '104',
					'name' => 'Israel',
					'iso2' => 'IL',
					'is_active' => true,
					'sequence' => '104'
				)
			),
			array(
				'Country' => array(
					'id' => '105',
					'name' => 'Italy',
					'iso2' => 'IT',
					'is_active' => true,
					'sequence' => '105'
				)
			),
			array(
				'Country' => array(
					'id' => '106',
					'name' => 'Jamaica',
					'iso2' => 'JM',
					'is_active' => true,
					'sequence' => '106'
				)
			),
			array(
				'Country' => array(
					'id' => '107',
					'name' => 'Japan',
					'iso2' => 'JP',
					'is_active' => true,
					'sequence' => '107'
				)
			),
			array(
				'Country' => array(
					'id' => '108',
					'name' => 'Jordan',
					'iso2' => 'JO',
					'is_active' => true,
					'sequence' => '108'
				)
			),
			array(
				'Country' => array(
					'id' => '109',
					'name' => 'Kazakhstan',
					'iso2' => 'KZ',
					'is_active' => true,
					'sequence' => '109'
				)
			),
			array(
				'Country' => array(
					'id' => '110',
					'name' => 'Kenya',
					'iso2' => 'KE',
					'is_active' => true,
					'sequence' => '110'
				)
			),
			array(
				'Country' => array(
					'id' => '111',
					'name' => 'Kiribati',
					'iso2' => 'KI',
					'is_active' => true,
					'sequence' => '111'
				)
			),
			array(
				'Country' => array(
					'id' => '112',
					'name' => 'Korea,  Democratic People\'s Republic of',
					'iso2' => 'KP',
					'is_active' => true,
					'sequence' => '112'
				)
			),
			array(
				'Country' => array(
					'id' => '113',
					'name' => 'Korea,  Republic of',
					'iso2' => 'KR',
					'is_active' => true,
					'sequence' => '113'
				)
			),
			array(
				'Country' => array(
					'id' => '114',
					'name' => 'Kuwait',
					'iso2' => 'KW',
					'is_active' => true,
					'sequence' => '114'
				)
			),
			array(
				'Country' => array(
					'id' => '115',
					'name' => 'Kyrgyzstan',
					'iso2' => 'KG',
					'is_active' => true,
					'sequence' => '115'
				)
			),
			array(
				'Country' => array(
					'id' => '116',
					'name' => 'Lao People\'s Democratic Republic',
					'iso2' => 'LA',
					'is_active' => true,
					'sequence' => '116'
				)
			),
			array(
				'Country' => array(
					'id' => '117',
					'name' => 'Latvia',
					'iso2' => 'LV',
					'is_active' => true,
					'sequence' => '117'
				)
			),
			array(
				'Country' => array(
					'id' => '118',
					'name' => 'Lebanon',
					'iso2' => 'LB',
					'is_active' => true,
					'sequence' => '118'
				)
			),
			array(
				'Country' => array(
					'id' => '119',
					'name' => 'Lesotho',
					'iso2' => 'LS',
					'is_active' => true,
					'sequence' => '119'
				)
			),
			array(
				'Country' => array(
					'id' => '120',
					'name' => 'Liberia',
					'iso2' => 'LR',
					'is_active' => true,
					'sequence' => '120'
				)
			),
			array(
				'Country' => array(
					'id' => '121',
					'name' => 'Libyan Arab Jamahiriya',
					'iso2' => 'LY',
					'is_active' => true,
					'sequence' => '121'
				)
			),
			array(
				'Country' => array(
					'id' => '122',
					'name' => 'Liechtenstein',
					'iso2' => 'LI',
					'is_active' => true,
					'sequence' => '122'
				)
			),
			array(
				'Country' => array(
					'id' => '123',
					'name' => 'Lithuania',
					'iso2' => 'LT',
					'is_active' => true,
					'sequence' => '123'
				)
			),
			array(
				'Country' => array(
					'id' => '124',
					'name' => 'Luxembourg',
					'iso2' => 'LU',
					'is_active' => true,
					'sequence' => '124'
				)
			),
			array(
				'Country' => array(
					'id' => '125',
					'name' => 'Macao',
					'iso2' => 'MO',
					'is_active' => true,
					'sequence' => '125'
				)
			),
			array(
				'Country' => array(
					'id' => '126',
					'name' => 'Macedonia,  the Former Yugoslav Republic of',
					'iso2' => 'MK',
					'is_active' => true,
					'sequence' => '126'
				)
			),
			array(
				'Country' => array(
					'id' => '127',
					'name' => 'Madagascar',
					'iso2' => 'MG',
					'is_active' => true,
					'sequence' => '127'
				)
			),
			array(
				'Country' => array(
					'id' => '128',
					'name' => 'Malawi',
					'iso2' => 'MW',
					'is_active' => true,
					'sequence' => '128'
				)
			),
			array(
				'Country' => array(
					'id' => '129',
					'name' => 'Malaysia',
					'iso2' => 'MY',
					'is_active' => true,
					'sequence' => '129'
				)
			),
			array(
				'Country' => array(
					'id' => '130',
					'name' => 'Maldives',
					'iso2' => 'MV',
					'is_active' => true,
					'sequence' => '130'
				)
			),
			array(
				'Country' => array(
					'id' => '131',
					'name' => 'Mali',
					'iso2' => 'ML',
					'is_active' => true,
					'sequence' => '131'
				)
			),
			array(
				'Country' => array(
					'id' => '132',
					'name' => 'Malta',
					'iso2' => 'MT',
					'is_active' => true,
					'sequence' => '132'
				)
			),
			array(
				'Country' => array(
					'id' => '133',
					'name' => 'Marshall Islands',
					'iso2' => 'MH',
					'is_active' => true,
					'sequence' => '133'
				)
			),
			array(
				'Country' => array(
					'id' => '134',
					'name' => 'Martinique',
					'iso2' => 'MQ',
					'is_active' => true,
					'sequence' => '134'
				)
			),
			array(
				'Country' => array(
					'id' => '135',
					'name' => 'Mauritania',
					'iso2' => 'MR',
					'is_active' => true,
					'sequence' => '135'
				)
			),
			array(
				'Country' => array(
					'id' => '136',
					'name' => 'Mauritius',
					'iso2' => 'MU',
					'is_active' => true,
					'sequence' => '136'
				)
			),
			array(
				'Country' => array(
					'id' => '137',
					'name' => 'Mayotte',
					'iso2' => 'YT',
					'is_active' => true,
					'sequence' => '137'
				)
			),
			array(
				'Country' => array(
					'id' => '138',
					'name' => 'Mexico',
					'iso2' => 'MX',
					'is_active' => true,
					'sequence' => '138'
				)
			),
			array(
				'Country' => array(
					'id' => '139',
					'name' => 'Micronesia,  Federated States of',
					'iso2' => 'FM',
					'is_active' => true,
					'sequence' => '139'
				)
			),
			array(
				'Country' => array(
					'id' => '140',
					'name' => 'Moldova,  Republic of',
					'iso2' => 'MD',
					'is_active' => true,
					'sequence' => '140'
				)
			),
			array(
				'Country' => array(
					'id' => '141',
					'name' => 'Monaco',
					'iso2' => 'MC',
					'is_active' => true,
					'sequence' => '141'
				)
			),
			array(
				'Country' => array(
					'id' => '142',
					'name' => 'Mongolia',
					'iso2' => 'MN',
					'is_active' => true,
					'sequence' => '142'
				)
			),
			array(
				'Country' => array(
					'id' => '143',
					'name' => 'Montserrat',
					'iso2' => 'MS',
					'is_active' => true,
					'sequence' => '143'
				)
			),
			array(
				'Country' => array(
					'id' => '144',
					'name' => 'Morocco',
					'iso2' => 'MA',
					'is_active' => true,
					'sequence' => '144'
				)
			),
			array(
				'Country' => array(
					'id' => '145',
					'name' => 'Mozambique',
					'iso2' => 'MZ',
					'is_active' => true,
					'sequence' => '145'
				)
			),
			array(
				'Country' => array(
					'id' => '146',
					'name' => 'Myanmar',
					'iso2' => 'MM',
					'is_active' => true,
					'sequence' => '146'
				)
			),
			array(
				'Country' => array(
					'id' => '147',
					'name' => 'Namibia',
					'iso2' => 'NA',
					'is_active' => true,
					'sequence' => '147'
				)
			),
			array(
				'Country' => array(
					'id' => '148',
					'name' => 'Nauru',
					'iso2' => 'NR',
					'is_active' => true,
					'sequence' => '148'
				)
			),
			array(
				'Country' => array(
					'id' => '149',
					'name' => 'Nepal',
					'iso2' => 'NP',
					'is_active' => true,
					'sequence' => '149'
				)
			),
			array(
				'Country' => array(
					'id' => '150',
					'name' => 'Netherlands',
					'iso2' => 'NL',
					'is_active' => true,
					'sequence' => '150'
				)
			),
			array(
				'Country' => array(
					'id' => '151',
					'name' => 'Netherlands Antilles',
					'iso2' => 'AN',
					'is_active' => true,
					'sequence' => '151'
				)
			),
			array(
				'Country' => array(
					'id' => '152',
					'name' => 'New Caledonia',
					'iso2' => 'NC',
					'is_active' => true,
					'sequence' => '152'
				)
			),
			array(
				'Country' => array(
					'id' => '153',
					'name' => 'New Zealand',
					'iso2' => 'NZ',
					'is_active' => true,
					'sequence' => '153'
				)
			),
			array(
				'Country' => array(
					'id' => '154',
					'name' => 'Nicaragua',
					'iso2' => 'NI',
					'is_active' => true,
					'sequence' => '154'
				)
			),
			array(
				'Country' => array(
					'id' => '155',
					'name' => 'Niger',
					'iso2' => 'NE',
					'is_active' => true,
					'sequence' => '155'
				)
			),
			array(
				'Country' => array(
					'id' => '156',
					'name' => 'Nigeria',
					'iso2' => 'NG',
					'is_active' => true,
					'sequence' => '156'
				)
			),
			array(
				'Country' => array(
					'id' => '157',
					'name' => 'Niue',
					'iso2' => 'NU',
					'is_active' => true,
					'sequence' => '157'
				)
			),
			array(
				'Country' => array(
					'id' => '158',
					'name' => 'Norfolk Island',
					'iso2' => 'NF',
					'is_active' => true,
					'sequence' => '158'
				)
			),
			array(
				'Country' => array(
					'id' => '159',
					'name' => 'Northern Mariana Islands',
					'iso2' => 'MP',
					'is_active' => true,
					'sequence' => '159'
				)
			),
			array(
				'Country' => array(
					'id' => '160',
					'name' => 'Norway',
					'iso2' => 'NO',
					'is_active' => true,
					'sequence' => '160'
				)
			),
			array(
				'Country' => array(
					'id' => '161',
					'name' => 'Oman',
					'iso2' => 'OM',
					'is_active' => true,
					'sequence' => '161'
				)
			),
			array(
				'Country' => array(
					'id' => '162',
					'name' => 'Pakistan',
					'iso2' => 'PK',
					'is_active' => true,
					'sequence' => '162'
				)
			),
			array(
				'Country' => array(
					'id' => '163',
					'name' => 'Palau',
					'iso2' => 'PW',
					'is_active' => true,
					'sequence' => '163'
				)
			),
			array(
				'Country' => array(
					'id' => '164',
					'name' => 'Palestinian Territory,  Occupied',
					'iso2' => 'PS',
					'is_active' => true,
					'sequence' => '164'
				)
			),
			array(
				'Country' => array(
					'id' => '165',
					'name' => 'Panama',
					'iso2' => 'PA',
					'is_active' => true,
					'sequence' => '165'
				)
			),
			array(
				'Country' => array(
					'id' => '166',
					'name' => 'Papua New Guinea',
					'iso2' => 'PG',
					'is_active' => true,
					'sequence' => '166'
				)
			),
			array(
				'Country' => array(
					'id' => '167',
					'name' => 'Paraguay',
					'iso2' => 'PY',
					'is_active' => true,
					'sequence' => '167'
				)
			),
			array(
				'Country' => array(
					'id' => '168',
					'name' => 'Peru',
					'iso2' => 'PE',
					'is_active' => true,
					'sequence' => '168'
				)
			),
			array(
				'Country' => array(
					'id' => '169',
					'name' => 'Philippines',
					'iso2' => 'PH',
					'is_active' => true,
					'sequence' => '169'
				)
			),
			array(
				'Country' => array(
					'id' => '170',
					'name' => 'Pitcairn',
					'iso2' => 'PN',
					'is_active' => true,
					'sequence' => '170'
				)
			),
			array(
				'Country' => array(
					'id' => '171',
					'name' => 'Poland',
					'iso2' => 'PL',
					'is_active' => true,
					'sequence' => '171'
				)
			),
			array(
				'Country' => array(
					'id' => '172',
					'name' => 'Portugal',
					'iso2' => 'PT',
					'is_active' => true,
					'sequence' => '172'
				)
			),
			array(
				'Country' => array(
					'id' => '173',
					'name' => 'Puerto Rico',
					'iso2' => 'PR',
					'is_active' => true,
					'sequence' => '173'
				)
			),
			array(
				'Country' => array(
					'id' => '174',
					'name' => 'Qatar',
					'iso2' => 'QA',
					'is_active' => true,
					'sequence' => '174'
				)
			),
			array(
				'Country' => array(
					'id' => '175',
					'name' => 'Reunion',
					'iso2' => 'RE',
					'is_active' => true,
					'sequence' => '175'
				)
			),
			array(
				'Country' => array(
					'id' => '176',
					'name' => 'Romania',
					'iso2' => 'RO',
					'is_active' => true,
					'sequence' => '176'
				)
			),
			array(
				'Country' => array(
					'id' => '177',
					'name' => 'Russian Federation',
					'iso2' => 'RU',
					'is_active' => true,
					'sequence' => '177'
				)
			),
			array(
				'Country' => array(
					'id' => '178',
					'name' => 'Rwanda',
					'iso2' => 'RW',
					'is_active' => true,
					'sequence' => '178'
				)
			),
			array(
				'Country' => array(
					'id' => '179',
					'name' => 'Saint Helena',
					'iso2' => 'SH',
					'is_active' => true,
					'sequence' => '179'
				)
			),
			array(
				'Country' => array(
					'id' => '180',
					'name' => 'Saint Kitts and Nevis',
					'iso2' => 'KN',
					'is_active' => true,
					'sequence' => '180'
				)
			),
			array(
				'Country' => array(
					'id' => '181',
					'name' => 'Saint Lucia',
					'iso2' => 'LC',
					'is_active' => true,
					'sequence' => '181'
				)
			),
			array(
				'Country' => array(
					'id' => '182',
					'name' => 'Saint Pierre and Miquelon',
					'iso2' => 'PM',
					'is_active' => true,
					'sequence' => '182'
				)
			),
			array(
				'Country' => array(
					'id' => '183',
					'name' => 'Saint Vincent and the Grenadines',
					'iso2' => 'VC',
					'is_active' => true,
					'sequence' => '183'
				)
			),
			array(
				'Country' => array(
					'id' => '184',
					'name' => 'Samoa',
					'iso2' => 'WS',
					'is_active' => true,
					'sequence' => '184'
				)
			),
			array(
				'Country' => array(
					'id' => '185',
					'name' => 'San Marino',
					'iso2' => 'SM',
					'is_active' => true,
					'sequence' => '185'
				)
			),
			array(
				'Country' => array(
					'id' => '186',
					'name' => 'Sao Tome and Principe',
					'iso2' => 'ST',
					'is_active' => true,
					'sequence' => '186'
				)
			),
			array(
				'Country' => array(
					'id' => '187',
					'name' => 'Saudi Arabia',
					'iso2' => 'SA',
					'is_active' => true,
					'sequence' => '187'
				)
			),
			array(
				'Country' => array(
					'id' => '188',
					'name' => 'Senegal',
					'iso2' => 'SN',
					'is_active' => true,
					'sequence' => '188'
				)
			),
			array(
				'Country' => array(
					'id' => '189',
					'name' => 'Serbia and Montenegro',
					'iso2' => 'CS',
					'is_active' => true,
					'sequence' => '189'
				)
			),
			array(
				'Country' => array(
					'id' => '190',
					'name' => 'Seychelles',
					'iso2' => 'SC',
					'is_active' => true,
					'sequence' => '190'
				)
			),
			array(
				'Country' => array(
					'id' => '191',
					'name' => 'Sierra Leone',
					'iso2' => 'SL',
					'is_active' => true,
					'sequence' => '191'
				)
			),
			array(
				'Country' => array(
					'id' => '192',
					'name' => 'Singapore',
					'iso2' => 'SG',
					'is_active' => true,
					'sequence' => '192'
				)
			),
			array(
				'Country' => array(
					'id' => '193',
					'name' => 'Slovakia',
					'iso2' => 'SK',
					'is_active' => true,
					'sequence' => '193'
				)
			),
			array(
				'Country' => array(
					'id' => '194',
					'name' => 'Slovenia',
					'iso2' => 'SI',
					'is_active' => true,
					'sequence' => '194'
				)
			),
			array(
				'Country' => array(
					'id' => '195',
					'name' => 'Solomon Islands',
					'iso2' => 'SB',
					'is_active' => true,
					'sequence' => '195'
				)
			),
			array(
				'Country' => array(
					'id' => '196',
					'name' => 'Somalia',
					'iso2' => 'SO',
					'is_active' => true,
					'sequence' => '196'
				)
			),
			array(
				'Country' => array(
					'id' => '197',
					'name' => 'South Africa',
					'iso2' => 'ZA',
					'is_active' => true,
					'sequence' => '197'
				)
			),
			array(
				'Country' => array(
					'id' => '198',
					'name' => 'South Georgia and the South Sandwich Islands',
					'iso2' => 'GS',
					'is_active' => true,
					'sequence' => '198'
				)
			),
			array(
				'Country' => array(
					'id' => '199',
					'name' => 'Spain',
					'iso2' => 'ES',
					'is_active' => true,
					'sequence' => '199'
				)
			),
			array(
				'Country' => array(
					'id' => '200',
					'name' => 'Sri Lanka',
					'iso2' => 'LK',
					'is_active' => true,
					'sequence' => '200'
				)
			),
			array(
				'Country' => array(
					'id' => '201',
					'name' => 'Sudan',
					'iso2' => 'SD',
					'is_active' => true,
					'sequence' => '201'
				)
			),
			array(
				'Country' => array(
					'id' => '202',
					'name' => 'Suriname',
					'iso2' => 'SR',
					'is_active' => true,
					'sequence' => '202'
				)
			),
			array(
				'Country' => array(
					'id' => '203',
					'name' => 'Svalbard and Jan Mayen',
					'iso2' => 'SJ',
					'is_active' => true,
					'sequence' => '203'
				)
			),
			array(
				'Country' => array(
					'id' => '204',
					'name' => 'Swaziland',
					'iso2' => 'SZ',
					'is_active' => true,
					'sequence' => '204'
				)
			),
			array(
				'Country' => array(
					'id' => '205',
					'name' => 'Sweden',
					'iso2' => 'SE',
					'is_active' => true,
					'sequence' => '205'
				)
			),
			array(
				'Country' => array(
					'id' => '206',
					'name' => 'Switzerland',
					'iso2' => 'CH',
					'is_active' => true,
					'sequence' => '206'
				)
			),
			array(
				'Country' => array(
					'id' => '207',
					'name' => 'Syrian Arab Republic',
					'iso2' => 'SY',
					'is_active' => true,
					'sequence' => '207'
				)
			),
			array(
				'Country' => array(
					'id' => '208',
					'name' => 'Taiwan,  Province of China',
					'iso2' => 'TW',
					'is_active' => true,
					'sequence' => '208'
				)
			),
			array(
				'Country' => array(
					'id' => '209',
					'name' => 'Tajikistan',
					'iso2' => 'TJ',
					'is_active' => true,
					'sequence' => '209'
				)
			),
			array(
				'Country' => array(
					'id' => '210',
					'name' => 'Tanzania,  United Republic of',
					'iso2' => 'TZ',
					'is_active' => true,
					'sequence' => '210'
				)
			),
			array(
				'Country' => array(
					'id' => '211',
					'name' => 'Thailand',
					'iso2' => 'TH',
					'is_active' => true,
					'sequence' => '211'
				)
			),
			array(
				'Country' => array(
					'id' => '212',
					'name' => 'Timor-Leste',
					'iso2' => 'TL',
					'is_active' => true,
					'sequence' => '212'
				)
			),
			array(
				'Country' => array(
					'id' => '213',
					'name' => 'Togo',
					'iso2' => 'TG',
					'is_active' => true,
					'sequence' => '213'
				)
			),
			array(
				'Country' => array(
					'id' => '214',
					'name' => 'Tokelau',
					'iso2' => 'TK',
					'is_active' => true,
					'sequence' => '214'
				)
			),
			array(
				'Country' => array(
					'id' => '215',
					'name' => 'Tonga',
					'iso2' => 'TO',
					'is_active' => true,
					'sequence' => '215'
				)
			),
			array(
				'Country' => array(
					'id' => '216',
					'name' => 'Trinidad and Tobago',
					'iso2' => 'TT',
					'is_active' => true,
					'sequence' => '216'
				)
			),
			array(
				'Country' => array(
					'id' => '217',
					'name' => 'Tunisia',
					'iso2' => 'TN',
					'is_active' => true,
					'sequence' => '217'
				)
			),
			array(
				'Country' => array(
					'id' => '218',
					'name' => 'Turkey',
					'iso2' => 'TR',
					'is_active' => true,
					'sequence' => '218'
				)
			),
			array(
				'Country' => array(
					'id' => '219',
					'name' => 'Turkmenistan',
					'iso2' => 'TM',
					'is_active' => true,
					'sequence' => '219'
				)
			),
			array(
				'Country' => array(
					'id' => '220',
					'name' => 'Turks and Caicos Islands',
					'iso2' => 'TC',
					'is_active' => true,
					'sequence' => '220'
				)
			),
			array(
				'Country' => array(
					'id' => '221',
					'name' => 'Tuvalu',
					'iso2' => 'TV',
					'is_active' => true,
					'sequence' => '221'
				)
			),
			array(
				'Country' => array(
					'id' => '222',
					'name' => 'Uganda',
					'iso2' => 'UG',
					'is_active' => true,
					'sequence' => '222'
				)
			),
			array(
				'Country' => array(
					'id' => '223',
					'name' => 'Ukraine',
					'iso2' => 'UA',
					'is_active' => true,
					'sequence' => '223'
				)
			),
			array(
				'Country' => array(
					'id' => '224',
					'name' => 'United Arab Emirates',
					'iso2' => 'AE',
					'is_active' => true,
					'sequence' => '224'
				)
			),
			array(
				'Country' => array(
					'id' => '225',
					'name' => 'United Kingdom',
					'iso2' => 'GB',
					'is_active' => true,
					'sequence' => '225',
				)
			),
			array(
				'Country' => array(
					'id' => '226',
					'name' => 'United States',
					'iso2' => 'US',
					'is_active' => true,
					'sequence' => '226',
				)
			),
			array(
				'Country' => array(
					'id' => '227',
					'name' => 'United States Minor Outlying Islands',
					'iso2' => 'UM',
					'is_active' => true,
					'sequence' => '227'
				)
			),
			array(
				'Country' => array(
					'id' => '228',
					'name' => 'Uruguay',
					'iso2' => 'UY',
					'is_active' => true,
					'sequence' => '228'
				)
			),
			array(
				'Country' => array(
					'id' => '229',
					'name' => 'Uzbekistan',
					'iso2' => 'UZ',
					'is_active' => true,
					'sequence' => '229'
				)
			),
			array(
				'Country' => array(
					'id' => '230',
					'name' => 'Vanuatu',
					'iso2' => 'VU',
					'is_active' => true,
					'sequence' => '230'
				)
			),
			array(
				'Country' => array(
					'id' => '231',
					'name' => 'Venezuela',
					'iso2' => 'VE',
					'is_active' => true,
					'sequence' => '231'
				)
			),
			array(
				'Country' => array(
					'id' => '232',
					'name' => 'Viet Nam',
					'iso2' => 'VN',
					'is_active' => true,
					'sequence' => '232'
				)
			),
			array(
				'Country' => array(
					'id' => '233',
					'name' => 'Virgin Islands,  British',
					'iso2' => 'VG',
					'is_active' => true,
					'sequence' => '233'
				)
			),
			array(
				'Country' => array(
					'id' => '234',
					'name' => 'Virgin Islands,  U.s.',
					'iso2' => 'VI',
					'is_active' => true,
					'sequence' => '234'
				)
			),
			array(
				'Country' => array(
					'id' => '235',
					'name' => 'Wallis and Futuna',
					'iso2' => 'WF',
					'is_active' => true,
					'sequence' => '235'
				)
			),
			array(
				'Country' => array(
					'id' => '236',
					'name' => 'Western Sahara',
					'iso2' => 'EH',
					'is_active' => true,
					'sequence' => '236'
				)
			),
			array(
				'Country' => array(
					'id' => '237',
					'name' => 'Yemen',
					'iso2' => 'YE',
					'is_active' => true,
					'sequence' => '237'
				)
			),
			array(
				'Country' => array(
					'id' => '238',
					'name' => 'Zambia',
					'iso2' => 'ZM',
					'is_active' => true,
					'sequence' => '238'
				)
			),
			array(
				'Country' => array(
					'id' => '239',
					'name' => 'Zimbabwe',
					'iso2' => 'ZW',
					'is_active' => true,
					'sequence' => '239'
				)
			)
		);
		return ClassRegistry::init('BuzzCustomers.Country')->saveMany($data);
	}

	protected function _populateUsStates() {
		$data = array(
			array(
				'UsState' => array(
					'id' => '1',
					'name' => 'Alabama',
					'code' => 'AL',
					'is_active' => true,
					'sequence' => '1'
				)
			),
			array(
				'UsState' => array(
					'id' => '2',
					'name' => 'Alaska',
					'code' => 'AK',
					'is_active' => true,
					'sequence' => '2'
				)
			),
			array(
				'UsState' => array(
					'id' => '3',
					'name' => 'Arizona',
					'code' => 'AZ',
					'is_active' => true,
					'sequence' => '3'
				)
			),
			array(
				'UsState' => array(
					'id' => '4',
					'name' => 'Arkansas',
					'code' => 'AR',
					'is_active' => true,
					'sequence' => '4'
				)
			),
			array(
				'UsState' => array(
					'id' => '5',
					'name' => 'California',
					'code' => 'CA',
					'is_active' => true,
					'sequence' => '5'
				)
			),
			array(
				'UsState' => array(
					'id' => '6',
					'name' => 'Colorado',
					'code' => 'CO',
					'is_active' => true,
					'sequence' => '6'
				)
			),
			array(
				'UsState' => array(
					'id' => '7',
					'name' => 'Connecticut',
					'code' => 'CT',
					'is_active' => true,
					'sequence' => '7'
				)
			),
			array(
				'UsState' => array(
					'id' => '8',
					'name' => 'Delaware',
					'code' => 'DE',
					'is_active' => true,
					'sequence' => '8'
				)
			),
			array(
				'UsState' => array(
					'id' => '9',
					'name' => 'Florida',
					'code' => 'FL',
					'is_active' => true,
					'sequence' => '9'
				)
			),
			array(
				'UsState' => array(
					'id' => '10',
					'name' => 'Georgia',
					'code' => 'GA',
					'is_active' => true,
					'sequence' => '10'
				)
			),
			array(
				'UsState' => array(
					'id' => '11',
					'name' => 'Hawaii',
					'code' => 'HI',
					'is_active' => true,
					'sequence' => '11'
				)
			),
			array(
				'UsState' => array(
					'id' => '12',
					'name' => 'Idaho',
					'code' => 'ID',
					'is_active' => true,
					'sequence' => '12'
				)
			),
			array(
				'UsState' => array(
					'id' => '13',
					'name' => 'Illinois',
					'code' => 'IL',
					'is_active' => true,
					'sequence' => '13'
				)
			),
			array(
				'UsState' => array(
					'id' => '14',
					'name' => 'Indiana',
					'code' => 'IN',
					'is_active' => true,
					'sequence' => '14'
				)
			),
			array(
				'UsState' => array(
					'id' => '15',
					'name' => 'Iowa',
					'code' => 'IA',
					'is_active' => true,
					'sequence' => '15'
				)
			),
			array(
				'UsState' => array(
					'id' => '16',
					'name' => 'Kansas',
					'code' => 'KS',
					'is_active' => true,
					'sequence' => '16'
				)
			),
			array(
				'UsState' => array(
					'id' => '17',
					'name' => 'Kentucky',
					'code' => 'KY',
					'is_active' => true,
					'sequence' => '17'
				)
			),
			array(
				'UsState' => array(
					'id' => '18',
					'name' => 'Louisiana',
					'code' => 'LA',
					'is_active' => true,
					'sequence' => '18'
				)
			),
			array(
				'UsState' => array(
					'id' => '19',
					'name' => 'Maine',
					'code' => 'ME',
					'is_active' => true,
					'sequence' => '19'
				)
			),
			array(
				'UsState' => array(
					'id' => '20',
					'name' => 'Maryland',
					'code' => 'MD',
					'is_active' => true,
					'sequence' => '20'
				)
			),
			array(
				'UsState' => array(
					'id' => '21',
					'name' => 'Massachusetts',
					'code' => 'MA',
					'is_active' => true,
					'sequence' => '21'
				)
			),
			array(
				'UsState' => array(
					'id' => '22',
					'name' => 'Michigan',
					'code' => 'MI',
					'is_active' => true,
					'sequence' => '22'
				)
			),
			array(
				'UsState' => array(
					'id' => '23',
					'name' => 'Minnesota',
					'code' => 'MN',
					'is_active' => true,
					'sequence' => '23'
				)
			),
			array(
				'UsState' => array(
					'id' => '24',
					'name' => 'Mississippi',
					'code' => 'MS',
					'is_active' => true,
					'sequence' => '24'
				)
			),
			array(
				'UsState' => array(
					'id' => '25',
					'name' => 'Missouri',
					'code' => 'MO',
					'is_active' => true,
					'sequence' => '25'
				)
			),
			array(
				'UsState' => array(
					'id' => '26',
					'name' => 'Montana',
					'code' => 'MT',
					'is_active' => true,
					'sequence' => '26'
				)
			),
			array(
				'UsState' => array(
					'id' => '27',
					'name' => 'Nebraska',
					'code' => 'NE',
					'is_active' => true,
					'sequence' => '27'
				)
			),
			array(
				'UsState' => array(
					'id' => '28',
					'name' => 'Nevada',
					'code' => 'NV',
					'is_active' => true,
					'sequence' => '28'
				)
			),
			array(
				'UsState' => array(
					'id' => '29',
					'name' => 'New Hampshire',
					'code' => 'NH',
					'is_active' => true,
					'sequence' => '29'
				)
			),
			array(
				'UsState' => array(
					'id' => '30',
					'name' => 'New Jersey',
					'code' => 'NJ',
					'is_active' => true,
					'sequence' => '30'
				)
			),
			array(
				'UsState' => array(
					'id' => '31',
					'name' => 'New Mexico',
					'code' => 'NM',
					'is_active' => true,
					'sequence' => '31'
				)
			),
			array(
				'UsState' => array(
					'id' => '32',
					'name' => 'New York',
					'code' => 'NY',
					'is_active' => true,
					'sequence' => '32'
				)
			),
			array(
				'UsState' => array(
					'id' => '33',
					'name' => 'North Carolina',
					'code' => 'NC',
					'is_active' => true,
					'sequence' => '33'
				)
			),
			array(
				'UsState' => array(
					'id' => '34',
					'name' => 'North Dakota',
					'code' => 'ND',
					'is_active' => true,
					'sequence' => '34'
				)
			),
			array(
				'UsState' => array(
					'id' => '35',
					'name' => 'Ohio',
					'code' => 'OH',
					'is_active' => true,
					'sequence' => '35'
				)
			),
			array(
				'UsState' => array(
					'id' => '36',
					'name' => 'Oklahoma',
					'code' => 'OK',
					'is_active' => true,
					'sequence' => '36'
				)
			),
			array(
				'UsState' => array(
					'id' => '37',
					'name' => 'Oregon',
					'code' => 'OR',
					'is_active' => true,
					'sequence' => '37'
				)
			),
			array(
				'UsState' => array(
					'id' => '38',
					'name' => 'Pennsylvania',
					'code' => 'PA',
					'is_active' => true,
					'sequence' => '38'
				)
			),
			array(
				'UsState' => array(
					'id' => '39',
					'name' => 'Rhode Island',
					'code' => 'RI',
					'is_active' => true,
					'sequence' => '39'
				)
			),
			array(
				'UsState' => array(
					'id' => '40',
					'name' => 'South Carolina',
					'code' => 'SC',
					'is_active' => true,
					'sequence' => '40'
				)
			),
			array(
				'UsState' => array(
					'id' => '41',
					'name' => 'South Dakota',
					'code' => 'SD',
					'is_active' => true,
					'sequence' => '41'
				)
			),
			array(
				'UsState' => array(
					'id' => '42',
					'name' => 'Tennessee',
					'code' => 'TN',
					'is_active' => true,
					'sequence' => '42'
				)
			),
			array(
				'UsState' => array(
					'id' => '43',
					'name' => 'Texas',
					'code' => 'TX',
					'is_active' => true,
					'sequence' => '43'
				)
			),
			array(
				'UsState' => array(
					'id' => '44',
					'name' => 'Utah',
					'code' => 'UT',
					'is_active' => true,
					'sequence' => '44'
				)
			),
			array(
				'UsState' => array(
					'id' => '45',
					'name' => 'Vermont',
					'code' => 'VT',
					'is_active' => true,
					'sequence' => '45'
				)
			),
			array(
				'UsState' => array(
					'id' => '46',
					'name' => 'Virginia',
					'code' => 'VA',
					'is_active' => true,
					'sequence' => '46'
				)
			),
			array(
				'UsState' => array(
					'id' => '47',
					'name' => 'Washington',
					'code' => 'WA',
					'is_active' => true,
					'sequence' => '47'
				)
			),
			array(
				'UsState' => array(
					'id' => '48',
					'name' => 'West Virginia',
					'code' => 'WV',
					'is_active' => true,
					'sequence' => '48'
				)
			),
			array(
				'UsState' => array(
					'id' => '49',
					'name' => 'Wisconsin',
					'code' => 'WI',
					'is_active' => true,
					'sequence' => '49'
				)
			),
			array(
				'UsState' => array(
					'id' => '50',
					'name' => 'Wyoming',
					'code' => 'WY',
					'is_active' => true,
					'sequence' => '50'
				)
			)
		);
		return ClassRegistry::init('BuzzCustomers.UsState')->saveMany($data);
	}
}
