<?php
$this->extend('/Common/2col');
$this->assign('title', $this->I18n->translate($data, 'Page.title'));
$this->start('side');
?>

	<?php if (!empty($data['Menu'])): ?>
		<ul class="nav--tertiary">
			<?php foreach ($data['Menu'] as $menuItem): ?>
				<li><?php echo $this->Html->link($this->I18n->translate($menuItem, 'name'), $menuItem['url']); ?></li>
			<?php endforeach; ?>
		</ul>
		<div class="content__spacer"></div>
	<?php endif; ?>

	<?php
		if (!empty($data['Advert'])):
			$adverts = count($data['Advert']);
			$i = 0;
			foreach ($data['Advert'] as $advert):
				echo $this->Advert->render($advert);
				++$i;
				echo $i < $adverts ? '<div class="content__spacer"></div>' : null;
			endforeach;
		endif;
	?>

<?php $this->end(); // side ?>

<?php if (!empty($data['Image'][0])): ?>
	<div class="text-center">
		<?php echo $this->Img->resize($data['Image'][0], ['width' => 870], ['class' => 'full']); ?>
	</div>
	<div class="content__spacer"></div>
<?php endif; ?>

<?php echo $this->I18n->translate($data, 'Page.body'); ?>

<?php if (!empty($gallery) || !empty($data['Page']['video_url'])): ?>
	<div class="row">
		<?php
			if (!empty($gallery)):
				$class = !empty($data['Page']['video_url']) ? 'col-md-6' : 'col-md-12';
		?>
			<div class="col-xs-12 <?php echo $class; ?>">
				<?php echo $this->element('BuzzGallery.mini_gallery', ['data' => $gallery['GalleryImage']]); ?>

				<div class="content__spacer"></div>
			</div>
		<?php endif; ?>

		<?php
			if (!empty($data['Page']['video_url'])):
				$class = !empty($gallery) ? 'col-md-6' : 'col-md-12';
		?>
			<div class="col-xs-12 <?php echo $class; ?>">
				<div class="aspect aspect--16_9">
					<!-- force iframe to full width 16:9 ratio with css -->
					<?php echo !empty($data['Page']['video_url']) ? $this->Video->embed($data['Page']['video_url'], ['width' => '100%', 'height' => '100%']) : null; ?>
				</div>
				<div class="content__spacer"></div>
			</div>
		<?php endif; ?>
	</div>
<?php endif; ?>

<?php if (!empty($data['Tab'])): ?>

	<div class="responsivetabs">
		<ul>
			<?php $i = 0; ?>
			<?php foreach ($data['Tab'] as $key => $tab): ?>
				<li><?php echo $this->Html->link($this->I18n->translate($tab, 'title'), '#tab-' . $key); ?></li>
			<?php endforeach; ?>
		</ul>
		<?php foreach ($data['Tab'] as $key => $tab): ?>
			<div id="tab-<?php echo $key; ?>">
				<?php echo !empty($tab['Image'][0]) ? $this->Img->resize($tab['Image'][0], ['width' => 870], ['class' => 'center full']) . '<br />' : null; ?>
				<?php echo $this->I18n->translate($tab, 'content'); ?>
			</div>
		<?php endforeach; ?>
	</div>
<?php endif; ?>
