<?php

App::uses('NumberHelper', 'View/Helper');

class NumberExtHelper extends NumberHelper {

/**
 * Returns a price with superscripted decimals
 *
 * @see NumberHelper::currency()
 */
	public function price($number, $currency = null, $options = array()) {
		$data = $this->currency($number, $currency, $options);
		return preg_replace('/([\.,]\d+)$/', '<sup>$1</sup>', $data);
	}

/**
 * Returns the currency symbol.
 *
 * @param string $currency
 * @return string
 */
	public function currencySymbol($currency = null) {
		$symbol = $this->currency(1, $currency, ['places' => 0]);
		return preg_replace('/\d/i', '', $symbol);
	}

}
