<?php
App::uses('AppHelper', 'View/Helper');

class MapHelper extends AppHelper {

	public $helpers = ['Html'];

/**
 * Render the markup for a Google Map (using the lat_lng defined in Site Settings as the default map
 * location).
 * @param array $options Attributes for the div, use to set the class, etc.
 * @param string $latLng Comma delimited list of latitude and longitude
 * @param int $zoom Map zoom level
 * @return string <div> markup for the map
 */
	public function render($options = [], $latLng = null, $zoom = 16) {
		$latLng = $latLng ?: Configure::read('SiteSetting.lat_lng');
		if (empty($latLng)) {
			return;
		}
		$map = json_decode($latLng);
		$options['data-lat'] = $map->latitude;
		$options['data-lng'] = $map->longitude;
		$options['data-zoomLevel'] = $zoom;
		$options['data-marker'] = 1;

		return $this->Html->tag('div', null, $options) . $this->Html->tag('/div');
	}

}
