<?php

App::uses('AppHelper', 'View');
App::uses('TextHelper', 'View/Helper');
App::uses('HtmlHelper', 'View/Helper');

class ListingHelper extends AppHelper {

	public $helpers = array('Html', 'Image', 'Text', 'Time', 'Number');

	public function nice($field, $attr, $item) {
		list($m, $f) = pluginSplit($field);

		if (isset($item[$m][$f])) {

			$value = $item[$m][$f];
		} elseif (isset($attr['default']) && ! empty($attr['default'])) {

			$value = $attr['default'];
		} else {

			$value = '';
		}

		if (!empty($attr['element'])) {
			return $this->_View->element($attr['element'], compact('item'));
		}

		switch ($attr['type']) {

			case 'text':
			case 'string':
				$truncateLength = !empty($attr['truncate']) && is_numeric($attr['truncate']) ? $attr['truncate'] : 50;
				return "<span title='" . strip_tags($value) . "'>" . $this->Text->truncate(strip_tags($value), $truncateLength) . "</span>";
				break;

			case 'image':
				return !empty($item['Image'][0]) ? $this->Image->resize($item['Image'][0], array('width' => 120, 'height' => 90)) : '';
				break;

			case 'boolean':
				if ($f == 'is_active' || $f == 'is_visible') {
					$class = $value == 1 ? 's--visible' : 's--invisible';
				} else {
					$class = $value == 1 ? 's--tick' : 's--untick';
				}
				return $this->Html->link("<i class='s $class'></i>", array('action' => 'toggle', $f, $item[$m]['id'], 'ajax' => true), array('escape' => false, 'class' => 'js--toggle'));
				break;

			case 'currency':
				$currency = isset($attr['currency']) ? $attr['currency'] : CakeNumber::defaultCurrency();
				return $this->Number->currency($value, $currency);
				break;

			case 'datetime_nice':
			case 'datetime':
				return !empty($value) ? $this->Time->format("jS M Y g:ia", $value) : '-';
				break;

			case 'date_nice':
			case 'date':
				return !empty($value) ? $this->Time->format("jS M Y", $value) : '-';
				break;

			default:
				return h($value);

		}
	}

}
