<?php
App::uses('AppHelper', 'View/Helper');
App::uses('CakeSession', 'Model/Datasource');

class GaHelper extends AppHelper {

	public $helpers = ['Html'];

/**
 * Returns JS for firing Google Analytics events.
 * @return string
 */
	public function sendEvents() {
		$return = [];
		if (CakeSession::check('ga.event')) {
			$events = CakeSession::read('ga.event');
			CakeSession::delete('ga.event');
			foreach ($events as $event => $description) {
				$event = stripcslashes($event);
				$description = stripcslashes($description);
				$return[] = "ga('send', 'event', '$event', '$description');";
			}
		}

		return ! empty($return) ? $this->Html->scriptBlock(implode("\n", $return)) : null;
	}

}
