<?php
	// Get the tracking ID
	if (! isset($tracking_code)) {
		$tracking_code = Configure::read('SiteSetting.google_analytics');
	}

	if (! isset($tracking_site)) {
		$site = $_SERVER['HTTP_HOST'];
	}
?>

<?php if ($tracking_code && Configure::read('app.environment') !== 'DEVELOPMENT'): ?>
	<script>
	  (function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
	  (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
	  m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
	  })(window,document,'script','//www.google-analytics.com/analytics.js','ga');

	  ga('create', '<?php echo $tracking_code; ?>', '<?php echo $tracking_site; ?>');
	  ga('send', 'pageview');

	  $(document).ready(function() {
		  	// Ensure that GA is loaded before listening for events
		    ga(function() {

		        // Fire GA event after 10 seconds for bounce rate measurement
		        setTimeout(function() {
		            ga('send', 'event', 'System', '10 Second Stay');
		        }, 10000);

		        // Track Mailto Links
		        $('a[href^="mailto:"]').click(function (event) {

		            event.preventDefault();
		            var address = $(this).attr('href');

		            ga('send', 'event', 'Contact', 'Click Email Address', address, {
		                'hitCallback': function () {
		                    document.location.href = address;
		                }
		            });
		        });

		        // Track Tel Links
		        $('a[href^="tel:"]').click(function (event) {

		            event.preventDefault();
		            var phoneNumber = $(this).attr('href');

		            ga('send', 'event', 'Contact', 'Click Phone Number', phoneNumber, {
		                'hitCallback': function () {
		                    document.location.href = phoneNumber;
		                }
		            });
		        });

		        // Track PDF Links
		        $('a[href$=".pdf"]').click(function (event) {

		            event.preventDefault();
		            var pdf = $(this).attr('href');

		            ga('send', 'event', 'Downloads', 'Download PDF', pdf, {
		                'hitCallback': function () {
		                    document.location.href = pdf;
		                }
		            });
		        });

		        // Track external links
		        $("a[href^='http:'],a[href^='https:']").not("[href*='<?= $tracking_site ?>']").click(function (event) {

		            event.preventDefault();
		            var address = $(this).attr('href');

		            ga('send', 'event', 'External', 'Clicked External Link', address, {
		                'hitCallback': function () {
		                    document.location.href = address;
		                }
		            });
		        });
		    });
	  });

	</script>
<?php endif; ?>
