<?php

class HomepageCtaTest extends CakeTestCase {

	public $fixtures = array(
		'plugin.ev_core.HomepageCta',
		'plugin.buzz_translate.Translation'
	);

	public function setUp() {
		parent::setUp();
		$this->HomepageCta = ClassRegistry::init('EvCore.HomepageCta');
	}

	public function testUrlValidation() {
		$this->HomepageCta->set(
			array(
				'url' => '/about-us'
			)
		);
		$result = $this->HomepageCta->validates();
		$this->assertTrue($result);

		$this->HomepageCta->set(
			array(
				'url' => 'http://example.com/'
			)
		);
		$result = $this->HomepageCta->validates();
		$this->assertTrue($result);

		$this->HomepageCta->set(
			array(
				'url' => 'about-us'
			)
		);
		$result = $this->HomepageCta->validates();
		$this->assertFalse($result);

		return;
	}

	public function testGetCtas() {
		$result = $this->HomepageCta->getCtas();
		$this->assertCount(3, $result);
		$this->assertEquals('Test #4', $result[2]['HomepageCta']['name']);

		return;
	}

}
