<?php

App::uses('Attachment', 'EvCore.Model');

/**
 * Image attachments.
 */
class Image extends Attachment {

	public $virtualFields = array(
		'filepath' => 'CONCAT("files/image/", id, "/", filename)'
	);

	public $actsAs = array(
		'Upload.Upload' => array(
			'filename' => array(
				'path' => '{ROOT}webroot{DS}files{DS}image{DS}',
				'nameCallback' => 'fixUploadFilename'
			)
		)
	);

/**
 * @see Attachment::beforeSave()
 */
	public function beforeSave($options = array()) {
		if (!parent::beforeSave($options)) {
			return false;
		}

		// Insert order number if creating image.
		if (!empty($this->id) && empty($this->data[$this->alias]['sequence'])) {

			$newData = $this->data;

			if (isset($newData[$this->alias]['filename'])) {

				// We are updating an image so check if is a new image file, if
				// so clear the cache.

				$oldData = $this->findById($this->id);

				// If name or size are different then remove cache.
				if ($newData[$this->alias]['attachment_type'] != $oldData[$this->alias]['attachment_type'] || $newData[$this->alias]['size'] != $oldData[$this->alias]['size']) {
					$this->__clearCachedImage($oldData[$this->alias]['attachment_type']);
				}
			}
		}

		return true;
	}

/**
 * @see Attachment::beforeDelete()
 */
	public function beforeDelete($cascade = true) {
		parent::beforeDelete($cascade);

		$data = $this->findById($this->id);

		if (!empty($data[$this->alias]) && file_exists($data[$this->alias]['filepath'])) {

			$success = unlink($data[$this->alias]['filepath']) && rmdir('files/image/' . $data[$this->alias]['dir']);

			// If the file has been successfully deleted we need to make sure
			// the cached files are cleared.
			if ($success) {
				$this->__clearCachedImage($data[$this->alias]['filename']);
			}

		}

		return true;
	}

/**
 * Clears all the images in the cache directory
 *
 * @note this will get slow for sites with large image cache
 * - dropping and recreating the cache directory might be quicker but might cause race conditions
 */
	private function __clearCachedImage($filename) {
		$cachedImages = glob('files' . DS . 'img_cache' . DS . "*$filename");

		foreach ($cachedImages as $img) {
			unlink($img);
		}

		return true;
	}

}
