<?php

App::uses('Validation', 'Utility');

class HomepageCta extends AppModel {

/**
 * Image slots
 *
 * @var array
 */
	public $imageSlots = array(
		'main' => array(
			'fields' => array(
			),
			'slots' => 1
		)
	);

/**
 * Behaviors
 *
 * @var array
 */
	public $actsAs = array(
		'BuzzTranslate.Translatable'
	);

/**
 * Validation rules
 *
 * @var array
 */
	public $validate = array(
		'name' => array(
			'required' => array(
				'rule' => 'notEmpty',
				'message' => 'Required'
			),
			'max' => array(
				'rule' => array('maxLength', 45),
				'message' => 'No more than 45 characters'
			)
		),
		'url' => array(
			'required' => array(
				'rule' => 'validateUrls',
				'message' => 'Invalid URL'
			)
		),
		'sequence' => array(
			'required' => array(
				'rule' => 'notEmpty',
				'message' => 'Required'
			),
			'max' => array(
				'rule' => array('naturalNumber', true)
			)
		),
	);

/**
 * Custom validation method for checking a URL (internal or external).
 *
 * @param array $data
 * @return bool
 */
	public function validateUrls(array $data) {
		$check = array_pop($data);

		$validates = preg_match('|^\/[\w\-_\/]+|', $check) === 1;
		if ($validates === false) {
			$validates = Validation::url($check);
		}

		return $validates;
	}

	public function getCtas($limit = 3) {
		$data = $this->find(
			'all',
			array(
				'contain' => array(
					'Image'
				),
				'conditions' => array(
					'HomepageCta.is_active' => true
				),
				'order' => array(
					'HomepageCta.sequence' => 'ASC'
				),
				'limit' => $limit
			)
		);
		return $data;
	}

}
