<?php

class TabbedBehavior extends ModelBehavior {

	public $settings = [];

/**
 * Initialise the behavior - store the settings against the model
 *
 * @see ModelBehavior::setup()
 */
	public function setup(Model $Model, $settings = []) {
		parent::setup($Model, $settings);

		$defaults = [
			'max_tabs' => 4
		];

		$this->settings[$Model->alias] = array_merge(
			$defaults,
			$settings
		);

		$Model->hasMany['Tab'] = array(
			'className' => 'EvCore.Tab',
			'foreignKey' => 'foreign_id',
			'conditions' => array(
				'model' => $Model->name
			),
			'dependent' => true,
			'cascade' => true
		);

		return;
	}

	public function beforeValidate(Model $Model, $options = array()) {
		if (!empty($Model->data['Tab'])) {
			// Set the model for the tab when saving.
			$Model->data['Tab'] = Hash::insert($Model->data['Tab'], '{n}.model', $Model->name);
		}
		return parent::beforeValidate($Model, $options);
	}

/**
 * Returns the maximum number of tabs for the model.
 *
 * @param Model $Model
 * @return int
 */
	public function getMaxTabs(Model $Model) {
		return $this->settings[$Model->alias]['max_tabs'];
	}

/**
 * Sets the maximum number of tabs for the model.
 *
 * @param Model $Model
 * @param int $max
 * @return void
 */
	public function setMaxTabs(Model $Model, $max) {
		$this->settings[$Model->alias]['max_tabs'] = $max;
	}

}
