<?php

abstract class Attachment extends AppModel {

	/**
	 * Number of document slots for the current model.
	 */
	public $documentSlots = 0;

	/**
	 * Defines number of image slots for the current model.
	 */
	public $imageSlots = 0;

	public $order = array(
		'sequence' => 'ASC'
	);


	/**
	 * @see AppModel::beforeSave()
	 */
	public function beforeSave($options = array()){

		if (!parent::beforeSave($options)) {
			return false;
		}

		// Insert sequence number if creating an attachment.
		if (empty($this->id) && empty($this->data[$this->alias]['sequence'])) {

			$this->data[$this->alias]['sequence'] = $this->getNextSequenceNo(array(
					'conditions' => array(
						'model' => $this->data[$this->alias]['model'],
						'model_id' => $this->data[$this->alias]['model_id'],
						'attachment_type' => $this->data[$this->alias]['attachment_type'],
					)
				)
			);

		}

		return true;

	}

	/**
	 * callback method for uploading, allows to prefix filenames to prevent collisions
	 *
	 * @param string $field Name of field being modified
	 * @param string $currentName current filename
	 * @param array $data Array of data being manipulated in the current request
	 * @param array $options Array of options for the current rename
	 * @return string
	 */
	public function fixUploadFilename($field, $currentName, $data, $options) {
		$currentName = preg_replace('/[^A-Za-z0-9\-_.]/', '', $currentName);
		return time() . '_' . str_replace(' ', '_', $currentName);
	}

}
