<?php

App::uses('CakeEventListener', 'Event');
App::uses('CustomEmail', 'Lib');

class EvUserPasswordResetListener implements CakeEventListener {

	public function implementedEvents() {
		return array(
			'Model.User.passwordReset' => 'sendPasswordResetEmail',
		);
	}

	public function sendPasswordResetEmail(CakeEvent $event) {
		$content = '<p>Please visit the following link to reset your password:-</p>';
		$content .= '<p><a href="' . $event->data['url'] . '">' . $event->data['url'] . '</a></p>';
		ClassRegistry::init('BuzzEmails.Email')->queueEmail(
			Configure::read('SiteSetting.site_title') . ' Password Reset',
			$content,
			(array)$event->data['User'][$event->data['Model']]['email'],
			[Configure::read('SiteSetting.admin_email') => Configure::read('SiteSetting.site_title')]
		);

		return;
	}

}
