<?php
App::uses('AppController', 'Controller');

class QueueController extends AppController {

	public $uses = ['Queue.QueuedTask'];

	/**
	 * List of admin actions the controller supports
	 */
	public $adminActions = array(
		'admin_index',
		'admin_clear'
	);

	/**
	 * QueueController::beforeFilter()
	 *
	 * @return void
	 */
	public function beforeFilter() {
		$this->QueuedTask->initConfig();

		// Set the display field.
		$this->QueuedTask->displayField = 'jobtype';

		parent::beforeFilter();
	}

	protected function _adminIndexColumnsWhitelist() {
		$whitelist = parent::_adminIndexColumnsWhitelist();

		$whitelist = [
			'QueuedTask.id',
			'QueuedTask.jobtype',
			'QueuedTask.created',
			'QueuedTask.fetched',
			'QueuedTask.completed',
			'QueuedTask.failed',
			'QueuedTask.failure_message'
		];

		return $whitelist;
	}

	protected function _adminIndexToolbar() {
		$toolbar = parent::_adminIndexToolbar();

		$toolbar = [
			'Clear Queue' => [
				'url' => ['action' => 'clear'],
				'icon' => 'undo'
			]
		];

		return $toolbar;
	}

	protected function _adminIndexActions() {
		$actions = parent::_adminIndexActions();

		$actions = [
			'Delete'
		];

		return $actions;
	}

	/**
	 * Truncate the queue list / table.
	 *
	 * @return void
	 * @throws MethodNotAllowedException when not posted
	 */
	public function admin_clear() {
		$this->request->allowMethod('get');
		$result = $this->QueuedTask->truncate();

		if ($result) {
			$this->Session->setFlash(
				array(
					'title' => __d('ev_core', 'Queue Cleared'),
					'description' => __d('ev_core', 'The queue has been emptied!')
				),
				'flash_success'
			);
		} else {
			$this->Session->setFlash(
				array(
					'title' => __d('ev_core', 'Unable to clear queue!')
				),
				'flash_fail'
			);
		}

		return $this->redirect(['action' => 'index']);
	}

}
