<?php

class HomepageCtasController extends AppController {

	public function __construct($request = null, $response = null) {
		parent::__construct($request, $response);

		$this->components['BuzzTranslate.Translation'] = [
			'fields' => [
				'name' => [
					'label' => Configure::read('EvCore.HomepageCtas.name') ?: 'Name'
				]
			]
		];
		if (Configure::read('EvCore.HomepageCtas.subtext') !== false) {
			$this->components['BuzzTranslate.Translation']['fields']['subtext'] = [
				'label' => Configure::read('EvCore.HomepageCtas.subtext')
			];
		}
	}

	public function admin_edit($id = null) {
		parent::admin_edit($id);
		$this->Translation->adminTranslationFormFields();

		return;
	}

/**
 * Admin form fields
 *
 * @return array
 */
	protected function _adminFormFields() {
		$fields = parent::_adminFormFields();
		$fields['HomepageCta.name']['label'] = Configure::read('EvCore.HomepageCtas.name') ?: 'Name';
		if (Configure::read('EvCore.HomepageCtas.subtext') === false) {
			unset($fields['HomepageCta.subtext']);
		} else {
			$fields['HomepageCta.subtext']['label'] = Configure::read('EvCore.HomepageCtas.subtext');
		}
		$fields['HomepageCta.url']['label'] = __d('admin', 'URL');

		return $fields;
	}

	protected function _adminIndexColumns() {
		$columns = parent::_adminIndexColumns();
		$columns['HomepageCta.name']['label'] = Configure::read('EvCore.HomepageCtas.name') ?: 'Name';

		return $columns;
	}

	protected function _adminFilterFields() {
		$fields = parent::_adminFilterFields();
		$fields['HomepageCta.name']['label'] = Configure::read('EvCore.HomepageCtas.name') ?: 'Name';

		return $fields;
	}

}
