<?php
$this->extend('/Common/2col');
$title = !empty($data['Page']['title']) ? $this->I18n->translate($data, 'Page.title') : __d('buzz_contact', 'Contact');
$this->assign('title', $title);
if (!empty($data['Page'])):
	$this->start('top');
?>
	<div class="row">
		<div class="col-xs-12 col-sm-9">
			<?php echo $this->I18n->translate($data, 'Page.body'); ?>
		</div>
	</div>
	<div class="row match-heights--parent">
		<?php foreach ($ctas as $key => $cta): ?>
			<?php echo $this->element('BuzzContact.enquiry_cta', ['data' => $cta, 'key' => $key]); ?>
		<?php endforeach; ?>
	</div>

	<div class="content__spacer"></div>
<?php
	$this->end(); // top
endif;
?>
<?php $this->start('side'); ?>

	<h2><?php echo $this->I18n->translate($data, 'Tab.1.title'); ?></h2>
	<?php echo $this->I18n->translate($data, 'Tab.1.content'); ?>

<?php $this->end(); // side ?>

<h2><?php echo $this->I18n->translate($data, 'Tab.0.title'); ?></h2>
<?php echo $this->I18n->translate($data, 'Tab.0.content'); ?>

<div class="row">
	<div class="col-xs-12 col-sm-8">

		<?php echo $this->Form->create('Enquiry', ['class' => 'form--side-labels validate']); ?>

			<?php
				echo $this->Form->inputs(
					array(
						'fieldset' => false,
						'Enquiry.name' => array(
							'label' => __d('buzz_contact', 'Name')
						),
						'Enquiry.email' => array(
							'label' => __d('buzz_contact', 'Email')
						),
						'Enquiry.telephone' => array(
							'label' => __d('buzz_contact', 'Telephone')
						),
						'Enquiry.enquiry_type_id' => array(
							'label' => __d('buzz_contact', 'Regarding'), 'empty' => __d('buzz_contact', 'Please Select')
						),
						'Enquiry.message' => array(
							'label' => __d('buzz_contact', 'Message')
						)
					)
				);

				echo $this->Form->button(__d('buzz_contact', 'Send Message') . '<i class="fa fa-chevron-circle-right fa-inline"></i>', ['class' => 'button']);
			?>

		<?php echo $this->Form->end(); ?>

	</div>
</div>
