<?php

App::uses('BuzzContactAppModel', 'BuzzContact.Model');

class EnquiryCta extends BuzzContactAppModel {

/**
 * Display name
 *
 * @var string
 */
	public $displayName = 'Enquiry Page Call to action';

/**
 * Display field
 *
 * @var string
 */
	public $displayField = 'title';

/**
 * Virtual fields
 *
 * Make all records protected by default.
 *
 * @var array
 */
	public $virtualFields = ['is_protected' => true];

/**
 * Behaviors
 *
 * @var array
 */
	public $actsAs = array(
		'BuzzTranslate.Translatable'
	);

/**
 * Validation rules
 *
 * @var array
 */
	public $validate = array(
		'title' => array(
			'required' => array(
				'rule' => 'notEmpty',
				'message' => 'Required'
			),
			'max' => array(
				'rule' => array('maxLength', 45),
				'message' => 'No more than 45 characters'
			)
		),
		'link_text' => array(
			'required' => array(
				'rule' => 'notEmpty',
				'message' => 'Required'
			),
			'max' => array(
				'rule' => array('maxLength', 45),
				'message' => 'No more than 45 characters'
			)
		),
		'url' => array(
			'required' => array(
				'rule' => 'validateUrls',
				'message' => 'Invalid URL'
			)
		),
		'small_text' => array(
			'max' => array(
				'rule' => array('maxLength', 45),
				'message' => 'No more than 45 characters',
				'allowEmpty' => true
			)
		),
		'sequence' => array(
			'required' => array(
				'rule' => 'notEmpty',
				'message' => 'Required'
			),
			'max' => array(
				'rule' => array('naturalNumber', true)
			)
		),
	);

/**
 * Custom validation method for checking a URL (internal or external).
 *
 * @param array $data
 * @return bool
 */
	public function validateUrls(array $data) {
		$check = array_pop($data);

		$validates = preg_match('|^\/[\w\-_\/]*|', $check) === 1;
		if ($validates === false) {
			$validates = Validation::url($check);
		}

		return $validates;
	}

/**
 * Get the calls to action.
 *
 * @param int $limit
 * @return array
 */
	public function getCtas($limit = 3) {
		$data = $this->find(
			'all',
			array(
				'conditions' => array(
					'EnquiryCta.is_active' => true
				),
				'order' => array(
					'EnquiryCta.sequence' => 'ASC'
				),
				'limit' => $limit
			)
		);
		return $data;
	}

}
