<?php

App::uses('BuzzContactAppModel', 'BuzzContact.Model');

class Enquiry extends BuzzContactAppModel {

/**
 * Belongs to associations
 *
 * @var array
 */
	public $belongsTo = array(
		'EnquiryType' => array(
			'className' => 'BuzzContact.EnquiryType'
		)
	);

/**
 * Validation rules
 *
 * @var array
 */
	public $validate = array(
		'name' => array(
			'required' => array(
				'rule' => 'notEmpty',
				'message' => 'Required'
			),
			'maxLength' => array(
				'rule' => array('maxLength', 100),
				'message' => 'No more than 100 characters long'
			)
		),
		'telephone' => array(
			'required' => array(
				'rule' => 'notEmpty',
				'message' => 'Required'
			),
			'telephone' => array(
				'rule' => '/^\+?[\d\ ]+$/',
				'message' => 'Not a valid telephone number'
			),
			'maxLength' => array(
				'rule' => array('maxLength', 20),
				'message' => 'No more than 20 characters long'
			)
		),
		'email' => array(
			'required' => array(
				'rule' => 'notEmpty',
				'message' => 'Required'
			),
			'email' => array(
				'rule' => 'email',
				'message' => 'Not a valid email address'
			),
			'maxLength' => array(
				'rule' => array('maxLength', 254),
				'message' => 'No more than 254 characters long'
			)
		),
		'enquiry_type_id' => array(
			'required' => array(
				'rule' => 'notEmpty',
				'message' => 'Required'
			)
		),
		'message' => array(
			'required' => array(
				'rule' => 'notEmpty',
				'message' => 'Required'
			)
		),
	);

	public function afterSave($created, $options = []) {
		parent::afterSave($created, $options);
		if ($created === true) {
			$Event = new CakeEvent('Model.Enquiry.created', $this, array(
				'id' => $this->id,
				'data' => $this->data[$this->alias]
			));
			$this->getEventManager()->dispatch($Event);
		}
		return;
	}

}
