<?php

App::uses('CakeEventListener', 'Event');
App::uses('CustomEmail', 'Lib');

class EnquiryListener implements CakeEventListener {

	public function implementedEvents() {
		return array(
			'Model.Enquiry.created' => 'sendEnquiryEmail'
		);
	}

	public function sendEnquiryEmail(CakeEvent $Event) {
		// Send the enquiry email
		$Email = new CustomEmail();

		$data = ClassRegistry::init('BuzzContact.Enquiry')->find(
			'first',
			array(
				'contain' => array(
					'EnquiryType'
				),
				'conditions' => array(
					'Enquiry.id' => $Event->data['id']
				)
			)
		);

		$Controller = new Controller();
		$Controller->helpers = ['BuzzTranslate.I18n'];
		$View = new View($Controller);
		$View->set('data', $data);
		$content = $View->render('BuzzContact./Emails/html/enquiry_email', 'ajax');

		$toEmail = Configure::read('SiteSetting.enquiry_email');
		$toEmail = $toEmail ?: Configure::read('SiteSetting.admin_email');

		$fromEmail = Configure::read('SiteSetting.from_email');
		$fromEmail = $fromEmail ?: Configure::read('SiteSetting.admin_email');

		$Email = ClassRegistry::init('BuzzEmails.Email');
		$Email->queueEmail(
			__d('buzz_contact', 'Site Enquiry (%s)', [Configure::read('SiteSetting.site_title')]),
			$content,
			[$toEmail => Configure::read('SiteSetting.site_title')],
			// We need to send emails from the admin address to avoid Mandrill rejecting them.
			[$fromEmail => Configure::read('SiteSetting.site_title')],
			null,
			null,
			null,
			// Set the reply-to address to be the enquirer's.
			[$data['Enquiry']['email'] => $data['Enquiry']['name']]
		);

		return;
	}

}
