<?php

App::uses('BuzzContactAppController', 'BuzzContact.Controller');

class EnquiryCtasController extends BuzzContactAppController {

/**
 * List of admin actions the controller supports
 *
 * @var array
 */
	public $adminActions = array(
		'admin_index',
		'admin_edit',
		'admin_toggle',
		'admin_reorder'
	);

/**
 * Components
 *
 * @var array
 */
	public $components = array(
		'BuzzTranslate.Translation' => array(
			'fields' => array(
				'title',
				'link_text',
				'small_text'
			)
		)
	);

/**
 * Admin add/edit
 *
 * @param int $id
 * @return void
 */
	public function admin_edit($id = null) {
		if (empty($id)) {
			throw new ForbiddenException();
		}
		parent::admin_edit($id);
		$this->Translation->adminTranslationFormFields();
		return;
	}

/**
 * Disable the 'add new' link from the admin index toolbar
 *
 * @return array
 */
	protected function _adminIndexToolbar() {
		$data = parent::_adminIndexToolbar();
		unset($data['Add New']);
		return $data;
	}

/**
 * Disable the admin form toolbar
 *
 * @return array
 */
	protected function _adminFormToolbar($id = null) {
		return [];
	}

	protected function _adminIndexActions() {
		return ['Edit'];
	}

/**
 * Remove filters, not necessary as there are only 3 CTAs
 *
 * @return array
 */
	protected function _adminFilterFields() {
		return [];
	}

}
