<?php

App::uses('BuzzContactAppController', 'BuzzContact.Controller');

class EnquiriesController extends BuzzContactAppController {

/**
 * List of admin actions the controller supports
 *
 * @var array
 */
	public $adminActions = array(
		'admin_index',
		'admin_delete',
		'admin_view'
	);

	public function beforeFilter() {
		parent::beforeFilter();

		$this->Auth->allow(array(
			'index'
		));
	}

/**
 * Contact form
 *
 * @return void
 */
	public function index() {
		$Enquiry = $this->{$this->modelClass};

		if (!empty($this->request->data)) {

			if ($Enquiry->save($this->request->data) !== false) {

				$this->Session->setFlash(
					__d('buzz_contact', 'Thank you'),
					'flash_success'
				);
				return $this->redirect($this->here);

			} else {

				$this->Session->setFlash(
					__d('buzz_contact', 'Please correct the errors below'),
					'flash_fail'
				);

			}

		}

		// Get page content.
		if (Configure::check('BuzzContact.page_id') === true) {
			$data = $this->assignPage(Configure::read('BuzzContact.page_id'));
		}

		$this->set('ctas', ClassRegistry::init('BuzzContact.EnquiryCta')->getCtas());
		$this->_populateLookups();
		$this->view = 'BuzzContact./Enquiries/index';

		return;
	}

	protected function _populateLookups() {
		$Enquiry = $this->{$this->modelClass};

		$this->set('enquiryTypes', $Enquiry->EnquiryType->getEnquiryTypes());

		return;
	}

/**
 * Admin index paginate
 *
 * @return array
 */
	protected function _adminIndexPaginate() {
		$conditions = $this->_processFilter();

		$paginate = array(
			'conditions' => $conditions,
			'contain' => array(
				'EnquiryType'
			)
		);

		return $paginate;
	}

/**
 * Admin index columns
 *
 * @return array
 */
	protected function _adminIndexColumns() {
		$columns = parent::_adminIndexColumns();

		unset($columns['Enquiry.modified']);

		$newColumns = array(
			'EnquiryType.name' => array(
				'label' => __d('buzz_contact', 'Enquiry Type'),
				'type' => 'string'
			)
		);

		return ArrayUtil::addAfter($columns, 'Enquiry.email', $newColumns);
	}

/**
 * Columns whitelist
 *
 * @var array
 */
	protected function _adminIndexColumnsWhitelist() {
		$Enquiry = $this->{$this->modelClass};
		$whitelist = parent::_adminIndexColumnsWhitelist();
		$whitelist[] = $Enquiry->alias . '.email';
		return $whitelist;
	}

/**
 * Filters
 *
 * @return array
 */
	protected function _adminFilterFields() {
		$filters = parent::_adminFilterFields();

		unset($filters['Enquiry.modified']);

		$newFilters = array(
			'Enquiry.email' => array(
				'label' => __d('buzz_contact', 'Email'),
				'type' => 'email',
				'compare' => array('Enquiry.email LIKE' => "%%%s%%")
			),
			'Enquiry.enquiry_type_id' => array(
				'label' => __d('buzz_contact', 'Enquiry Type'),
				'type' => 'select',
				'compare' => array('Enquiry.enquiry_type_id' => "%s")
			)
		);

		return ArrayUtil::addAfter($filters, 'Enquiry.name', $newFilters);
	}

/**
 * Populate admin lookups
 *
 * @return void
 */
	protected function _adminPopulateLookups() {
		$this->_populateLookups();
		return;
	}

	protected function _adminIndexActions() {
		return array(
			'Delete',
			'Admin View'
		);
	}

/**
 * Disable the 'add new' link from the admin index toolbar
 *
 * @return array
 */
	protected function _adminIndexToolbar() {
		return [];
	}

	protected function _adminFormToolbar($id = null) {
		$data = parent::_adminFormToolbar($id);
		unset($data['Add New']);
		return $data;
	}

}
