<?php

App::uses('BuzzConditionsAppModel', 'BuzzConditions.Model');

class Condition extends BuzzConditionsAppModel {

/**
 * Behaviors
 *
 * @var array
 */
	public $actsAs = array(
		'BuzzTranslate.Translatable'
	);

	public $validate = array(
		'name' => array(
			'required' => array(
				'rule' => 'notEmpty',
				'message' => 'Required'
			),
			'max' => array(
				'rule' => array('maxLength', 45),
				'message' => 'No more than 45 characters'
			)
		),
		'content' => array(
			'required' => array(
				'rule' => 'notEmpty',
				'message' => 'Required'
			)
		),
	);

/**
 * After find logic
 *
 * @param array $results
 * @param bool $primary
 * @return array
 */
	public function afterFind($results, $primary = false) {
		$results = parent::afterFind($results, $primary);

		foreach ($results as &$result) {
			if (!empty($result[$this->alias]['content'])) {
				$result[$this->alias]['rendered_content'] = $this->_renderContent($result[$this->alias]['content']);
			}
			if (!empty($result[$this->alias]['__i18n'])) {
				foreach ($result[$this->alias]['__i18n'] as &$lang) {
					if (!empty($lang['content']['content'])) {
						$lang['content']['rendered_content'] = $this->_renderContent($lang['content']['content']);
					}
				}
			}
		}

		return $results;
	}

/**
 * Render condition content replacing Markdown style links with HTML link tags
 *
 * @param string $string Content to render
 * @return string Rendered content
 */
	protected function _renderContent($string) {
		return preg_replace_callback(
			'/\[(.*?)\]\((.*?)\)/',
			function ($matches) {
				return '<a href="' . $matches[2] . '" target="_blank">' . $matches[1] . '</a>';
			},
			htmlspecialchars($string)
		);
	}

/**
 * Returns all visible conditions for the given model
 *
 * @param string $model
 * @return array
 */
	public function getConditions($model) {
		$params = array(
			'conditions' => array(
				'Condition.model' => $model,
				'Condition.is_active' => true
			),
			'order' => array(
				'Condition.sequence' => 'ASC'
			)
		);
		return $this->find('all', $params);
	}

}
