<?php

App::uses('BuzzConditionsAppController', 'BuzzConditions.Controller');

abstract class ConditionsController extends BuzzConditionsAppController {

/**
 * Model for filtering conditions (set when extending).
 *
 * @var string
 */
	public $conditionModel = null;

	public $uses = ['BuzzConditions.Condition'];

	public $components = array(
		'BuzzTranslate.Translation' => array(
			'fields' => array(
				'content' => array(
					'type' => 'text_plain'
				)
			)
		)
	);

	public function admin_edit($id = null) {
		if (!empty($this->request->data) && empty($id)) {
			$this->request->data['Condition']['model'] = $this->conditionModel;
		}
		parent::admin_edit($id);
		$this->Translation->adminTranslationFormFields();
		return;
	}

	protected function _adminFormFields() {
		$fields = parent::_adminFormFields();

		unset($fields['Condition.model']);
		unset($fields['Condition.has_voucher']);

		$fields['Condition.content']['type'] = 'text_plain';

		return $fields;
	}

	protected function _adminIndexPaginate() {
		$paginate = parent::_adminIndexPaginate();

		$paginate['conditions']['Condition.model'] = $this->conditionModel;

		return $paginate;
	}

	public function admin_reorder() {
		parent::admin_reorder();
		// Remove any conditions not related to the current condition model.
		// This is a bit of a backwards approach, but there is currently no
		// simple way of extending admin_reorder's data.
		$this->viewVars['data'] = Hash::remove(
			$this->viewVars['data'],
			'{n}.Condition[model!=' . $this->conditionModel . ']'
		);
		return;
	}

}
