<?php
$this->extend('/Common/2col');
$this->assign('title', $this->I18n->translate($data, 'Competition.name'));
$this->start('side');
?>
	<?php
		if ($data['Competition']['is_open'] === true):
			echo $this->Fa->link('chevron-circle-right fa-inline', __d('buzz_competitions', 'Enter Competition'), ['controller' => 'competition_entries', 'action' => 'enter', $data['Competition']['id']], ['class' => 'button button--fill', 'space' => false]);
		endif;
	?>

	<div class="content__spacer"></div>

	<?php
		$adverts = count($data['Advert']);
		$i = 0;
		foreach ($data['Advert'] as $advert):
			echo $this->Advert->render($advert);
			++$i;
			echo $i < $adverts ? '<div class="content__spacer"></div>' : null;
		endforeach;
	?>
<?php $this->end(); // side ?>

<?php if (!empty($data['Image'][0])): ?>
	<div class="text-center">
		<?php echo $this->Img->resize($data['Image'][0], ['width' => 870], ['class' => 'full']); ?>
	</div>
	<div class="content__spacer"></div>
<?php endif; ?>

<div class="content__intro">
	<?php echo $this->I18n->translate($data, 'Competition.content'); ?>
</div>
<?php if (!empty($data['Competition']['secondary_content'])): ?>
	<div class="toggle__content">
		<?php echo $this->I18n->translate($data, 'Competition.secondary_content'); ?>
	</div>
	<p class="toggle"><?php echo __d('buzz_competitions', 'Read More'); ?><i class="fa fa-chevron-circle-down fa-inline"></i></p>
<?php endif; ?>

<div class="text-center<?php if (empty($data['Tab']) && empty($gallery) && empty($data['Competition']['video_url']) && $data['Competition']['is_open'] === true): ?> xs-hidden<?php endif; ?>">
	<?php if ($data['Competition']['is_open'] === true): ?>
		<?php echo $this->Fa->link('chevron-circle-right', __d('buzz_competitions', 'Enter Now'), ['controller' => 'competition_entries', 'action' => 'enter', $data['Competition']['id']], ['class' => 'button']); ?>
	<?php elseif (CakeTime::isFuture($data['Competition']['open_date'])): ?>
		<strong><?php echo __d('buzz_competitions', 'Open for Entries: %s', $this->Time->i18nFormat($data['Competition']['open_date'], '%e %B %Y')); ?></strong>
	<?php else: ?>
		<strong><?php echo __d('buzz_competitions', 'Closed for Entries'); ?></strong>
	<?php endif; ?>
</div>

<div class="content__spacer"></div>

<?php if (!empty($gallery) || !empty($data['Competition']['video_url'])): ?>
	<div class="row">
		<?php
			if (!empty($gallery)):
				$class = !empty($data['Competition']['video_url']) ? 'col-md-6' : 'col-md-12';
		?>
			<div class="col-xs-12 <?php echo $class; ?>">
				<?php echo $this->element('BuzzGallery.mini_gallery', ['data' => $gallery['GalleryImage']]); ?>

				<div class="content__spacer"></div>
			</div>
		<?php endif; ?>

		<?php
			if (!empty($data['Competition']['video_url'])):
				$class = !empty($gallery) ? 'col-md-6' : 'col-md-12';
		?>
			<div class="col-xs-12 <?php echo $class; ?>">
				<div class="aspect aspect--16_9">
					<!-- force iframe to full width 16:9 ratio with css -->
					<?php echo $this->Video->embed($data['Competition']['video_url'], ['width' => '100%', 'height' => '100%']); ?>
				</div>
				<div class="content__spacer"></div>
			</div>
		<?php endif; ?>
	</div>
<?php endif; ?>

<?php if (!empty($data['Tab']) && count($data['Tab']) > 1): ?>

	<div class="responsivetabs">
		<ul>
			<?php $i = 0; ?>
			<?php foreach ($data['Tab'] as $key => $tab): ?>
				<li><?php echo $this->Html->link($this->I18n->translate($tab, 'title'), '#tab-' . $key); ?></li>
			<?php endforeach; ?>
		</ul>
		<?php foreach ($data['Tab'] as $key => $tab): ?>
			<div id="tab-<?php echo $key; ?>"><?php echo $this->I18n->translate($tab, 'content'); ?></div>
		<?php endforeach; ?>
	</div>

<?php elseif (!empty($data['Tab'])): ?>

	<h2><?php echo $this->I18n->translate($data, 'Tab.0.title'); ?></h2>
	<?php echo $this->I18n->translate($data, 'Tab.0.content'); ?>

<?php endif; ?>
