<?php
$this->extend('/Common/view');
$this->assign('title', __d('buzz_competitions', '%s Entry Form', [$data['Competition']['name']]));
echo $this->Html->script(['BuzzCompetitions.buzz_competitions.min'], ['inline' => false]);
// We ideally don't want search engines indexing the entry form so set the
// robots meta tag.
$this->assign('meta', '<meta name="robots" content="noindex" />');
?>
<?php echo $this->Form->create(null, ['class' => 'validate']); ?>

<?php echo $this->element('BuzzCompetitions.competition_basket'); ?>

<div class="row">
	<div class="col-xs-12 col-md-6">
		<h3><?php echo __d('buzz_competitions', 'Team Details'); ?></h3>
		<div class="form--side-labels form--compact validate">
			<div class="input select required">
				<label for="CompetitionEntryCompetitionCategoryId"><?php echo __d('buzz_competitions', 'Category'); ?></label>
				<?php
					$options[] = $this->Html->tag(
						'option',
						__d('buzz_competitions', 'Please select'),
						[
							'value' => '',
							'data-participants' => $data['Competition']['max_participants']
						]
					);

					foreach ($data['CompetitionCategory'] as $category):
						$options[] = $this->Html->tag(
							'option',
							$this->I18n->translate($category, 'name'),
							[
								'value' => $category['id'],
								'data-participants' => $category['participants']
							]
						);
					endforeach;
					echo $this->Html->tag('select', implode('', $options), ['name' => 'data[CompetitionEntry][competition_category_id]', 'id' => 'CompetitionEntryCompetitionCategoryId', 'required' => 'required']);
				?>
			</div>
			<?php echo $this->Form->input('CompetitionEntry.team_name', ['label' => __d('buzz_competitions', 'Team name')]); ?>
			<?php echo $this->Form->input('CompetitionEntry.team_country_id', ['label' => __d('buzz_competitions', 'Team country')]); ?>
			<?php echo $this->Form->input('CompetitionEntry.alternate_name', ['label' => __d('buzz_competitions', 'Alternate name')]); ?>
		</div>
	</div>
	<div class="col-xs-12 col-md-6">
		<h3><?php echo __d('buzz_competitions', 'Team Members'); ?></h3>
		<div class="form--side-labels form--compact validate">
			<?php
				for ($participant = 0; $participant < $data['Competition']['max_participants']; $participant++):
					echo $this->Form->input('CompetitionEntryParticipant..id', ['type' => 'hidden']);
					$label = __d('buzz_competitions', 'Team member %d', [$participant + 1]);
					if ($participant === 0) {
						$label = __d('buzz_competitions', 'Team Captain');
					}
					echo $this->Form->input(
						'CompetitionEntryParticipant.' . $participant . '.name',
						[
							'label' => $label,
							'data-participant' => $participant + 1,
							'div' => 'input js-participant'
						]
					);
				endfor;
			?>
		</div>
	</div>
</div>

<div class="content__spacer">&nbsp;</div>

<div class="row">
	<div class="col-xs-12 col-md-6">

		<h3><?php echo __d('buzz_competitions', 'Billing Details'); ?></h3>

		<div class="form--side-labels form--compact validate">

			<?php echo $this->Element('BuzzCustomers.address_form'); ?>
			<?php echo $this->Form->input('CustomerAddress.email', ['label' => __d('buzz_competitions', 'Email')]); ?>
			<?php echo $this->Form->input('CustomerAddress.telephone', ['label' => __d('buzz_competitions', 'Telephone')]); ?>

		</div>

	</div>
	<div class="col-xs-12 col-md-6">

		<?php if (Configure::read('BuzzPurchase.onsite') === true): ?>
			<h3><?php echo __d('buzz_competitions', 'Payment details'); ?></h3>
			<div class="form--side-labels form--compact validate">
				<?php echo $this->element('BuzzPurchase.Forms/payment_form'); ?>
			</div>
			<div class="content__spacer">&nbsp;</div>
		<?php endif; ?>

		<?php foreach ($conditions as $condition): ?>
			<div class="input checkbox checkbox--custom checkbox--left clear">
				<?php echo $this->Form->checkbox('condition.' . $condition['Condition']['id'], ['class' => 'required']); ?>
				<?php echo $this->Form->label('condition.' . $condition['Condition']['id'], $condition['Condition']['rendered_content']); ?>
			</div>
		<?php endforeach; ?>

		<?php if (Configure::read('BuzzCompetitions.show_newsletter_opt_in') === true): ?>
			<div class="input checkbox checkbox--custom checkbox--left clear">
				<?= $this->Form->checkbox('CompetitionEntry.newsletter_opt_in') ?>
				<?= $this->Form->label('CompetitionEntry.newsletter_opt_in', __d('buzz_competitions', 'Signup to Exclusive Offers & News')) ?>
			</div>
		<?php endif; ?>

	</div>
</div>

<div class="booking__actions">
	<div class="row">
		<div class="col-xs-6">
			<?php echo $this->Html->link(__d('buzz_competitions', 'Back'), ['controller' => 'competitions', 'action' => 'view', $data['Competition']['id']], ['class' => 'button button--light background--septenary left']); ?>
		</div>

		<div class="col-xs-6">
			<?php echo $this->Form->button(__d('buzz_competitions', 'Enter Team & Pay') . '<i class="fa fa-credit-card fa-inline"></i>', ['class' => 'button button--dark background--senary right']); ?>
		</div>
	</div>
</div>

<?php echo $this->Form->end(); ?>
