<?php $this->Extend('/Scaffolds/admin_form'); ?>
<?php $this->Append('additionalFormTabs'); ?>

	<?php
		if ((int)$authUser['UserGroup']['id'] === 1):
			if (!empty($competitionEntry['CompetitionEntry']['api_log'])):
				echo $this->Html->tag(
					'div',
					'<pre>' .  print_r(json_decode($competitionEntry['CompetitionEntry']['api_log']), 1) . '</pre>',
					['class' => 'tab__content', 'data-title' => __d('buzz_competitions', 'API Errors')]
				);
			endif;
			echo $this->Html->tag(
				'div',
				$this->element('BuzzSource.api_log'),
				['class' => 'tab__content', 'data-title' => __d('buzz_competitions', 'API Calls')]
			);
		endif;
	?>

<?php $this->end(); // additionalFormTabs end ?>
<?php

	echo $this->Form->addField('CompetitionEntry.id', array(
		'type' => 'hidden'
	));

	echo $this->Form->addField(
		'CompetitionEntry.sales_ref',
		array(
			'type' => 'string',
			'label' => __d('buzz_competitions', 'Sales Ref'),
			'displayonly' => true
		)
	);

	echo $this->Form->addField(
		'CompetitionEntry.competition_id',
		array(
			'type' => 'select',
			'label' => __d('buzz_competitions', 'Competition'),
			'empty' => false,
			'displayonly' => true
		)
	);

	echo $this->Form->addField(
		'CompetitionEntry.competition_entry_state_id',
		array(
			'type' => 'select',
			'label' => __d('buzz_competitions', 'Status'),
			'empty' => false,
			'displayonly' => true
		)
	);

	echo $this->Form->addField(
		'CompetitionEntry.completed_date',
		array(
			'type' => 'date',
			'label' => __d('buzz_competitions', 'Completed Date'),
			'displayonly' => true
		)
	);
	echo $this->Form->addField(
		'CustomerAddress.full_name',
		array(
			'type' => 'string',
			'label' => __d('buzz_competitions', 'Customer'),
			'displayonly' => true
		)
	);

	echo $this->Form->addField(
		'CustomerAddress.email',
		array(
			'type' => 'email',
			'label' => __d('buzz_competitions', 'Email Address')
		)
	);

	echo $this->Form->addField(
		'CustomerAddress.telephone',
		array(
			'type' => 'tel',
			'label' => __d('buzz_competitions', 'Telephone')
		)
	);

	echo $this->Form->addField(
		'CompetitionEntry.competition_category_id',
		array(
			'type' => 'string',
			'label' => __d('buzz_competitions', 'Category'),
			'displayonly' => true
		)
	);

	echo $this->Form->addField(
		'CompetitionEntry.team_name',
		array(
			'type' => 'string',
			'label' => __d('buzz_competitions', 'Team Name'),
			'displayonly' => true
		)
	);

	echo $this->Form->addField(
		'CompetitionEntry.team_country_id',
		array(
			'type' => 'string',
			'label' => __d('buzz_competitions', 'Team Country'),
			'displayonly' => true
		)
	);

	echo $this->Form->addField(
		'CompetitionEntry.alternate_name',
		array(
			'type' => 'select',
			'label' => __d('buzz_competitions', 'Alternate Name'),
			'displayonly' => true
		)
	);

	echo $this->Form->addField(
		'CompetitionEntry.team_captain',
		array(
			'type' => 'string',
			'label' => __d('buzz_competitions', 'Team Captain'),
			'displayonly' => true
		)
	);

	echo $this->Form->addField(
		'CompetitionEntry.participants',
		array(
			'type' => 'string',
			'label' => __d('buzz_competitions', 'Team Members'),
			'displayonly' => true
		)
	);
?>

<div class="field">
	<div class="field__label"><?php echo __d('buzz_competitions', 'Total Cost'); ?></div>
	<div class="field__value">
		<?php echo $this->Number->currency($competitionEntry['CompetitionEntry']['total_cost']); ?>
	</div>
</div>

<?php if (Configure::read('BuzzCompetitions.show_newsletter_opt_in') === true): ?>
	<div class="field">
		<div class="field__label">Newsletter Opt-in</div>
		<div class="field__value">
			<?php if ($competitionEntry['CompetitionEntry']['newsletter_opt_in']): ?>
				<i class="fa fa-check"></i>
			<?php else: ?>
				<i class="fa fa-times"></i>
			<?php endif; ?>
		</div>
	</div>
<?php endif; ?>
