<?php

App::uses('CakeEventListener', 'Event');

class CompetitionEntryListener implements CakeEventListener {

	public function implementedEvents() {
		return array(
			'Model.CompetitionEntry.completed' => 'confirmation'
		);
	}

	public function confirmation(CakeEvent $Event) {
		$purchase = ClassRegistry::init('BuzzCompetitions.CompetitionEntry')->getPurchase($Event->data['id']);

		if (!empty($purchase['CompetitionEntry']['sales_ref'])) {
			$Email = ClassRegistry::init('BuzzEmails.Email');
			$email = ClassRegistry::init('BuzzEmails.Email')->generateEmailData(
				'BuzzCompetitions.confirmation_email',
				[
					'competition' => $purchase['Competition']['name'],
					'category' => $purchase['CompetitionCategory']['name'],
					'teamName' => $purchase['CompetitionEntry']['team_name'],
					'teamCountry' => $purchase['TeamCountry']['name'],
					'alternateName' => $purchase['CompetitionEntry']['alternate_name'],
					'teamMembers' => CakeText::toList(
						Hash::extract(
							$purchase,
							'CompetitionEntryParticipant.{n}.name'
						)
					),
					'fullName' => $purchase['CustomerAddress']['first_name'] . ' ' . $purchase['CustomerAddress']['last_name'],
					'firstName' => $purchase['CustomerAddress']['first_name'],
					'lastName' => $purchase['CustomerAddress']['last_name'],
					'salesRef' => $purchase['CompetitionEntry']['sales_ref']
				]
			);
			$Email->queueEmail(
				$email['Email']['subject'],
				$email['Email']['content'],
				array($purchase['CustomerAddress']['email'] => $purchase['CustomerAddress']['first_name'] . ' ' . $purchase['CustomerAddress']['last_name']),
				$email['Email']['from'],
				null,
				null,
				$purchase['Competition']['email']
			);
		}

		return;
	}

}
