<?php

App::uses('BuzzCompetitionsAppController', 'BuzzCompetitions.Controller');

class CompetitionsController extends BuzzCompetitionsAppController {

	public $components = array(
		'BuzzAdverts.Adverts',
		'BuzzTranslate.Translation' => array(
			'fields' => array(
				'name',
				'content' => array(
					'type' => 'html'
				),
				'secondary_content' => array(
					'type' => 'html'
				)
			),
			'meta' => true
		)
	);

	public function __construct($request = null, $response = null) {
		$this->adminActions[] = 'admin_adverts';
		parent::__construct($request, $response);
	}

	public function beforeFilter() {
		parent::beforeFilter();

		$this->Auth->allow(array(
			'view'
		));
	}

	public function view($id) {
		$Competition = $this->{$this->modelClass};

		$data = $Competition->readForView($id);
		if (empty($data)) {
			throw new NotFoundException();
		}
		$this->Meta->canonical(['action' => 'view', $id]);
		$this->set(compact('data'));
		$this->view = 'BuzzCompetitions.view';

		return;
	}

	public function admin_edit($id = null) {
		parent::admin_edit($id);
		$this->Adverts->setupAdvertAdminFields();
		$this->Translation->adminTranslationFormFields();
		return;
	}

	/**
	 * Admin form fields
	 *
	 * @return array
	 */
	protected function _adminFormFields() {
		$fields = parent::_adminFormFields();

		$fields['Competition.content']['type'] = 'html';
		$fields['Competition.secondary_content']['type'] = 'html';

		$newFields['CompetitionCategory.CompetitionCategory'] = array(
			'label' => __d('buzz_competitions', 'Categories'),
			'type' => 'multicheck'
		);

		$fields = ArrayUtil::addAfter($fields, 'Competition.api_reference', $newFields);

		$fields['Competition.site_id']['empty'] = false;

		return $fields;
	}

	/**
	 * Populate admin lookups
	 *
	 * @return void
	 */
	protected function _adminPopulateLookups() {
		$Competition = $this->{$this->modelClass};

		$this->set('themes', $Competition->Theme->find('list'));

		if (CakePlugin::loaded('BuzzGallery') === true) {
			$this->set('galleries', $Competition->Gallery->find('list'));
		}

		$this->set('competitionCategories', $Competition->CompetitionCategory->find('list'));

		$this->loadModel('BuzzSites.Site');
		$this->set('sites', $this->Site->getList());

		return;
	}

	protected function _adminFormToolbar($id = null) {
		$toolbar = parent::_adminFormToolbar($id);

		$toolbar['Adverts'] = array(
			'url' => array('action' => 'adverts', $id),
			'icon' => 'bars'
		);

		return $toolbar;
	}

	/**
	 * Admin index columns whitelist
	 *
	 * @return array
	 */
	protected function _adminIndexColumnsWhitelist() {
		$whitelist = parent::_adminIndexColumnsWhitelist();

		$whitelist[] = 'Competition.open_date';
		$whitelist[] = 'Competition.closing_date';

		return $whitelist;
	}

	/**
	 * Admin filters
	 *
	 * @return array
	 */
	protected function _adminFilterFields() {
		$filters = parent::_adminFilterFields();

		$newFilters = [
			'Competition.open_date' => [
				'label' => 'Open Date',
				'type' => 'date',
				'compare' => ['Competition.open_date' => '%s']
			],
			'Competition.closing_date' => [
				'label' => 'Closing Date',
				'type' => 'date',
				'compare' => ['Competition.closing_date' => '%s']
			]
		];

		return ArrayUtil::addAfter($filters, 'Competition.name', $newFilters);
	}

}
