<?php
class BuzzCompetitionsSetupEmail extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'BuzzCompetitions_setup_email';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
		),
		'down' => array(
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		if ($direction === 'up') {
			$EmailGroup = ClassRegistry::init('BuzzEmails.EmailGroup');
			$data = array(
				'name' => 'Competitions'
			);
			$EmailGroup->save($data);
			$data = array(
				array(
					'name' => 'Competition Entry Confirmation',
					'system_name' => 'BuzzCompetitions.confirmation_email',
					'email_group_id' => $EmailGroup->id,
					'subject' => 'Your {competition} Competition Entry {salesRef}',
					'content' => '<p>Hi {firstName},</p><p><strong>Your Sales Reference Number is: {salesRef}</strong></p><p>Thanks for entering the {competition} competition.</p><p><strong>Category:</strong> {category}</p><p><strong>Team Name:</strong> {teamName}</p><p><strong>Team Country:</strong> {teamCountry}</p><p><strong>Alternate Name:</strong> {alternateName}</p><p><strong>Team Members:</strong> {teamMembers}</p>',
					'required_tokens' => '["salesRef","competition"]',
					'optional_tokens' => '["fullName","firstName","lastName","category","teamName","teamCountry","alternateName","teamMembers"]'
				),
			);
			ClassRegistry::init('BuzzEmails.Email')->saveMany($data);
		}
		return true;
	}
}
