<?php
if (isset($kiosk) && $kiosk):
	$this->extend('BuzzWaivers.Common/kiosk_view');
else:
	$this->extend('/Common/view');
endif;

$this->assign('title', __d('buzz_check_bookings', 'Check My Bookings'));
?>

<div class="outline--septenary outline--thin background--white padding-gutters-1_2">
	<div class="row">
		<div class="col-xs-12 col-sm-7 col-sm-push-1">
			<?php echo $this->Form->create('CheckBooking', ['class' => 'form--side-labels validate']); ?>

			<h3><?php echo __d('buzz_check_bookings', 'Please enter your booking\'s contact details'); ?></h3>

			<?php
				echo $this->Form->inputs(array(
					'fieldset' => false,
					'CheckBooking.email' => array('type' => 'email', 'label' => __d('buzz_check_bookings', 'Email')),
					'CheckBooking.telephone' => array(
						'label' => __d('buzz_check_bookings', 'Telephone')
					)
				));
				echo $this->Form->button(__d('buzz_check_bookings', 'Check') . '<i class="fa fa-chevron-circle-right fa-inline"></i>', ['class' => 'button']);
			?>

			<?php echo $this->Form->end(); ?>

		</div>
	</div>
</div>

<div class="content__spacer"></div>

<?php 
if (!isset($kiosk) || !$kiosk):
	echo $this->Fa->link(
		'chevron-circle-left fa-inline',
		__d('buzz_check_bookings', 'Go Back'),
		'javascript:history.back()',
		['before' => true, 'space' => false, 'class' => 'button button--light background--septenary left']
	);
endif;
?>
