<?php
if (isset($kiosk) && $kiosk):
	$this->extend('BuzzWaivers.Common/kiosk_view');
else:
	$this->extend('/Common/view');
endif;

$this->assign('title', __d('buzz_check_bookings', 'Check My Bookings'));

?>

<?php if (!empty($data)): ?>
	<div class="row">
		<div class="col-xs-12">
			<div class="buzz-check-bookings-bookings outline--septenary outline--thin background--white padding-gutters-1_2 basket">
				<?php foreach ($data as $ref => $bookings): ?>
					<h3>
						<?php if (! empty($ref)): ?>
							<?= __d('buzz_check_bookings', 'Booking %s', [$ref]) ?>
						<?php else: ?>
							<?= __d('buzz_check_bookings', 'Pro Flyer Bookings') ?>
						<?php endif; ?>

						<?php if (Configure::read('BuzzSites.show_location')): ?>
							 - <?php echo __d('buzz_check_bookings', '%s', [$bookings[0]['location']]); ?>
						<?php endif; ?>
					</h3>

					<?php foreach ($bookings as $item): ?>
						<div class="listing listing--booking">
							<div class="row">
								<div class="col-xs-12 col-sm-3 xs-extra-gutters-1 sm-plus-extra-gutters-2--left">
									<h3><?php echo $item['description']; ?></h3>
								</div>
								<div class="col-xs-12 xs-extra-gutters-1 col-sm-2">
									<span class="h3"><?php echo $this->Time->i18nFormat(strtotime($item['date']), '%e %b %Y'); ?></span>
								</div>
								<div class="col-xs-12 xs-extra-gutters-1 col-sm-2">
									<strong><?php echo __d('buzz_check_bookings', 'Time:'); ?></strong>
									<span class="h3"><?php echo date('H:i', strtotime($item['date'])); ?></span>
								</div>
								<div class="col-xs-12 xs-extra-gutters-1 col-sm-1 xs-text-left text-right fa--senary">
									<?php if (!empty($item['participants'])): ?>
										<?php if ($item['participants'] < 5): ?>
											<?php for ($i = 0; $i < $item['participants']; $i++): ?>
												<i class="fa fa-user"></i>
											<?php endfor; ?>
										<?php else: ?>
											<i class="fa fa-users"></i>
										<?php endif; ?>
										<strong><?php echo $item['participants']; ?></strong>
									<?php endif; ?>
								</div>
								<div class="col-xs-12 xs-extra-gutters-1 col-sm-3">
									<?php echo $item['message']; ?>
								</div>
							</div>
						</div>
						<?php if (! empty($showWaivers) && $item['status'] !== 'ERROR'): ?>
							<?= $this->element('BuzzWaivers.CheckWaiver/button', ['data' => $item]) ?>
							<br />
						<?php endif; ?>
					<?php endforeach; ?>


				<?php endforeach; ?>

			</div>
		</div>
	</div>
<?php else: ?>
	<?= $this->Session->flash(); ?>
	<?php
	echo $this->Fa->link(
		'chevron-circle-left fa-inline',
		__d('buzz_check_bookings', 'Go Back'),
		'javascript:history.back()',
		['before' => true, 'space' => false, 'class' => 'button button--light background--septenary left']
	);
	?>
<?php endif; ?>
