<?php

App::uses('BuzzCheckBookingsAppModel', 'BuzzCheckBookings.Model');

class CheckBooking extends BuzzCheckBookingsAppModel {

	public $useTable = false;

	public $validate = [
		'email' => [
			'email' => [
				'rule' => 'email',
				'message' => 'Valid email addresses only',
				'allowEmpty' => true
			]
		],
		'telephone' => [
			'telephone' => [
				'rule' => ['phone', '/^\+?[0-9 ]+/'],
				'message' => 'Valid phone numbers only',
				'allowEmpty' => true
			]
		]
	];

	/**
	 * Checks the API for bookings for the supplied contact details.
	 *
	 * @param array $data Array of contact details
	 * @return array|bool
	 */
	public function checkBookings(array $data) {
		$this->set($data);

		if (
			$this->validates() === true
			&& !empty($data[$this->alias]['email'])
			|| !empty($data[$this->alias]['telephone'])
		) {
			$BookingsCheckerApi = ClassRegistry::init('BuzzCheckBookings.BookingsCheckerApi');
			$results = $BookingsCheckerApi->getBookings(
				$data[$this->alias]['email'],
				$data[$this->alias]['telephone']
			);
			// Group the bookings by sales ref.
			$return = [];
			foreach ($results as $value) {
				$return[$value['reference']][] = $value;
			}

			return $return;
		}

		return false;
	}

}
