<?php

App::uses('BuzzSourceAppModel', 'BuzzSource.Model');

class BookingsCheckerApi extends BuzzSourceAppModel {

	/**
	 * Get vouchers for an activity type at a specific site
	 *
	 * @param string $email Customer email
	 * @param string $telephone Customer telephone number
	 * @return array
	 */
	public function getBookings($email, $telephone = null) {
		$result = $this->find('all', array(
			'method' => 'ConfirmBooking',
			'conditions' => array(
				'email' => $email,
				'telephone' => $telephone
			)
		));

		return !empty($result['BookingsCheckerApi']['d']) ? $this->_processBookings($result['BookingsCheckerApi']['d']) : [];
	}

	/**
	 * Process bookings data from the API
	 *
	 * @param array $data Response from API
	 * @return array
	 */
	protected function _processBookings($data) {
		$result = [];

		foreach ($data as $booking) {
			$result[] = [
				'contact_name' => $booking['ContactName'],
				'location' => $booking['Location'],
				'reference' => $booking['Reference'],
				'date' => $this->cleanApiDate($booking['BookingDate']),
				'check_in' => $booking['CheckInMins'],
				'description' => $booking['Description'],
				'participants' => $booking['Participants'],
				'message' => $booking['FailureDescription'],
				'status' => $booking['Status']
			];
		}

		return $result;
	}

}
