<?php

App::uses('BuzzCheckBookingsAppController', 'BuzzCheckBookings.Controller');

class CheckBookingsController extends BuzzCheckBookingsAppController {

	public function beforeFilter() {
		parent::beforeFilter();

		$this->Auth->allow(array(
			'check'
		));
	}

	public function check() {
		$CheckBooking = $this->{$this->modelClass};

		if (!empty($this->request->data)) {
			$data = $CheckBooking->checkBookings($this->request->data);
			if (!empty($data)) {
				if (CakePlugin::loaded('BuzzWaivers') && Configure::read('BuzzWaivers.showOnCheckBooking') == true) {
					$this->BookingCheck = $this->Components->load('BuzzWaivers.BookingCheck');
					$this->BookingCheck->setController($this);
					$data = $this->BookingCheck->check($data);
				}

				$this->set(compact('data'));
				$this->view = 'BuzzCheckBookings.bookings';
				return;
			} elseif ($data !== false) {
				$this->Session->setFlash(__d('buzz_check_bookings', 'You currently have no upcoming bookings'), 'flash_info');
				$this->set(compact('data'));
				$this->view = 'BuzzCheckBookings.bookings';
				return;
			} else {
				$this->Session->setFlash(__d('buzz_check_bookings', 'Please correct the errors below'), 'flash_fail');
			}
		}
		$this->Meta->canonical(['action' => 'check']);
		$this->view = 'BuzzCheckBookings.check';

		return;
	}

}
