<?php

	$controller = $this->request->params['controller'];
	$action = $this->request->params['action'];

	$links = [
		[
			'name' => __d('buzz_camps', 'Overview'),
			'url' => ['controller' => 'camps', 'action' => 'account_index'],
			'active' => $controller === 'camps' && in_array(
				$action,
				['account_index', 'account_edit_camp', 'account_bookings', 'account_camps', 'account_past_camps', 'account_delete_booking', 'account_add_booking']
			)
		],
		[
			'name' => __d('buzz_camps', 'My Profile'),
			'url' => ['controller' => 'camps', 'action' => 'account_profile'],
			'active' => $controller === 'camps' && $action === 'account_profile'
		]
	];

	$tabs = '';
	foreach ($links as $link):

		$tabs .= $this->Html->tag(
			'li',
			$this->Html->link($link['name'], $link['url']),
			['class' => 'r-tabs-tab' . ($link['active'] ? ' r-tabs-state-active' : null)]
		);

	endforeach;

	echo $this->Html->tag('ul', $tabs, ['class' => 'r-tabs-nav']);
