<div class="overflow-auto">
	<table class="table--flat">
		<thead>
			<tr>
				<th><?php echo __d('buzz_camps', 'Date') ?></th>
				<th><?php echo __d('buzz_camps', 'Name') ?></th>
				<?php if(Configure::read('BuzzSites.show_location')): ?>
					<th><?php echo __d('buzz_camps', 'Location') ?></th>
				<?php endif; ?>
				<th><?php echo __d('buzz_camps', 'Available') ?></th>
				<th><?php echo __d('buzz_camps', 'Cost') ?></th>
				<th><?php echo __d('buzz_camps', 'Bookable') ?></th>
				<th></th>
			</tr>
		</thead>
		<tbody>
			<?php if (empty($data)): ?>
				<tr>
					<td colspan="6"><?php echo __d('buzz_camps', 'No upcoming camps'); ?></td>
				</tr>
			<?php else: ?>
				<?php foreach ($data as $row): ?>
					<tr>
						<td>
							<?php echo $this->Time->i18nFormat(strtotime($row['Camp']['date']), '%d/%m/%Y'); ?>
						</td>
						<td>
							<?php echo !empty($noLink) ? h($row['Camp']['name']) : $this->Html->link($row['Camp']['name'], ['action' => 'view', $row['Camp']['id']]); ?>
						</td>

						<?php if(Configure::read('BuzzSites.show_location')): ?>
							<td>
								<?php
								$site = $this->I18n->translate($sites[$row['Camp']['site_id']], 'Site.name');

								echo (! empty($site) ? $site : '-');
								?>
							</td>
						<?php endif; ?>
						<td>
							<?php echo $row['Camp']['remaining_availability'] . ' / ' . $row['Camp']['slots_available']; ?>
						</td>
						<td>
							<?php echo $this->Number->currency($row['Camp']['cost']); ?>
						</td>
						<td>
							<?php echo $row['Camp']['is_bookable'] ? __d('buzz_camps', 'Yes') : __d('buzz_camps', 'No'); ?>
						</td>
						<td>
							<?php echo !empty($edit) ? $this->Html->link(__d('buzz_camps', 'Edit'), ['action' => 'account_edit_camp', $row['Camp']['id']]) : null; ?>
							<?php echo $this->Html->link(__d('buzz_camps', 'Copy'), ['action' => 'account_edit_camp', $row['Camp']['id'], 1]); ?>
							<?php echo $this->Html->link(__d('buzz_camps', 'Bookings'), ['action' => 'account_bookings', $row['Camp']['id']]); ?>
						</td>
					</tr>
				<?php endforeach; ?>

				<?php if (!empty($paged)): ?>
					<tr>
						<?php
							$page = empty($page) ? 1 : $page + 1;
							echo $this->Html->tag(
								'td',
								$this->Html->link(__d('buzz_camps', 'Load More'), ['action' => 'get_next_camps', $page, $limit, empty($edit)], ['class' => 'js-load-next']),
								['colspan' => 6]
							);
						?>
					</tr>
				<?php endif; // Pager ?>
			<?php endif; ?>
		</tbody>
	</table>
</div>
