<?php if (!empty($data)): ?>

	<?php foreach ($data as $month => $camps): ?>

		<?php if ($this->Time->isThisMonth($month)): ?>
			<h2><?= __d('buzz_camps', 'This Month') ?></h2>
		<?php else: ?>
			<h2><?= $this->Time->format($month . '-01', '%B %Y') ?></h2>
		<?php endif; ?>

		<?php foreach ($camps as $camp): ?>
			<?php $url = ['controller' => 'camps', 'action' => 'view', $camp['Camp']['id']]; ?>
			<div class="listing listing--activity"  itemscope itemtype="http://schema.org/Event">
				<div class="row">
					<div class="col-xs-12 col-sm-3 col-md-2_9">
						<?php
							$img = 'avatar.png';
							if (!empty($camp['Image'][0]['filename'])) {
								$img = $camp['Image'][0];
							} elseif (!empty($camp['AccountProfile']['Image'][0]['filename'])) {
								$img = $camp['AccountProfile']['Image'][0];
							}
							echo $this->Img->resize($img, ['width' => 468, 'height' => 356, 'crop' => true], ['class' => 'listing__image', 'url' => $url]);
						?>
						<div class="content__spacer xs-visible"></div>
					</div>

					<div class="col-xs-12 col-sm-6 col-md-5_9">
						<div class="row">
							<div class="col-xs-12 col-sm-12">
								<h3><?php echo $this->Html->link('<span itemprop="name">' . __d('buzz_camps', '%s\'s %s', [$camp['AccountProfile']['display_name'], $camp['Camp']['name']]) . '</span>', $url, ['itemprop' => 'url', 'escape' => false]); ?></h3>
								<p itemprop="startDate" content="<?php echo $this->Time->i18nFormat($camp['Camp']['date'], '%F'); ?>"><strong><?php echo $this->Time->i18nFormat($camp['Camp']['date'], '%A %e %B %Y'); ?></strong>
								<?php if(Configure::read('BuzzSites.show_location')): ?>
									<br><strong><?=__d('buzz_camps', 'Location:')?></strong> <?=$this->I18n->translate($camp, 'Site.name')?>
								<?php endif; ?>
								</p>
							</div>
						</div>

						<p><?php echo $camp['Camp']['tag_line']; ?></p>
					</div>

					<div class="col-xs-12 col-sm-3 col-md-2_9 text-center">
						<div class="listing__price no-padding">
							<h3><?php echo $this->Number->price($camp['Camp']['cost']); ?> <small>(<?php echo __d('buzz_camps', 'Per Person'); ?>)</small><br /></h3>
						</div>
						<div class="listing__note">
							<i class="fa fa-user"></i> <?php echo __d('buzz_camps', '%s Spaces Available', '<strong>' . $camp['Camp']['remaining_availability'] . '</strong>'); ?>
						</div>
						<?php if ($camp['Camp']['remaining_availability'] > 0): ?>
							<?= $this->Fa->link('chevron-circle-right', __d('buzz_camps', 'Find out more'), $url, ['class' => 'button button--fill']); ?>
						<?php else: ?>
							<strong><?= __d('buzz_camps', 'Sold Out') ?></strong>
						<?php endif ?>
					</div>
				</div>

				<div class="row">
					<div class="xs-hidden col-md-2_9">&nbsp;</div>
					<div class="col-xs-12 col-md-7_9"><hr /></div>
				</div>
			</div>
		<?php endforeach; ?>

	<?php endforeach; ?>

<?php else: ?>

	<div class='flash flash--fail'>
		<?php
			echo $this->Element(
				'_flash',
				array('message' => __d('buzz_camps', 'There are no up coming camps'))
			);
		?>
	</div>

<?php endif; ?>
