<div class="row">
	<div class="col-xs-12">
		<div class="outline--septenary outline--thin background--white padding-gutters-1_2 basket">

			<h3><?php echo !empty($paid) ? __d('buzz_camps', 'Your booking:') : __d('buzz_camps', 'You are booking:'); ?></h3>

			<div class="listing listing--booking">
				<div class="row">

					<div class="col-xs-12 col-sm-6 xs-extra-gutters-1--left sm-plus-extra-gutters-2--left">
						<h3><?php echo $this->Html->link($data['Camp']['name'], ['action' => 'view', 'controller' => 'camps', $data['Camp']['id']]); ?>
						</h3>
						<?php if(Configure::read('BuzzSites.show_location')): ?>
							<strong><?=__d('buzz_camps', 'Location:')?></strong> <?=$this->I18n->translate($site, 'Site.name')?>
						<?php endif; ?>
					</div>

					<div class="col-xs-4 col-sm-2 xs-extra-gutters-1--left">
						<strong><?php echo __d('buzz_camps', 'Date:'); ?></strong>
						<span><?php echo $this->Time->i18nFormat($data['Camp']['date'], '%d/%m/%Y'); ?></span>
					</div>

					<div class="col-xs-4 col-sm-2">
						<strong><?php echo __d('buzz_camps', 'Time:'); ?></strong>
						<span><?php echo $data['Camp']['time']; ?></span>
					</div>

					<div class="col-xs-4 col-sm-2">
						<strong><?php echo __d('buzz_camps', 'Price:'); ?></strong>
						<span class="large"><?php echo $this->Number->price($data['Camp']['cost']); ?></span>
					</div>

				</div>
			</div>

			<?php
				// Temporary hack to put VAT on Bodyflight baskets until a proper VAT solution is
				// built. This will want removing once we can properly handle VAT across the sites.
			?>
			<?php if (! empty($paid) && Configure::check('BuzzPurchase.taxPercent')): ?>
				<div class="row">
					<div class="col-xs-12 basket__total text-right">
						<strong>
							<?= (Configure::check('BuzzPurchase.taxLabel') ? Configure::read('BuzzPurchase.taxLabel') : __('Tax')) ?> <span>
								<?php
									if (Configure::read('BuzzPurchase.showAmount') && Configure::check('BuzzPurchase.showPercent')) {
										echo "(" . Configure::read('BuzzPurchase.taxPercent') . "%) " . $this->Purchase->tax($data['Camp']['cost']);
									} elseif (Configure::read('BuzzPurchase.showAmount')) {
										echo $this->Purchase->tax($data['Camp']['cost']);
									} elseif (Configure::check('BuzzPurchase.showPercent')) {
										echo Configure::read('BuzzPurchase.taxPercent') . "%";
									}
								?>
							</span>
						</strong>
					</div>
				</div>
			<?php endif; ?>

			<div class="row">
				<div class="col-xs-12 basket__total text-right">
					<strong><?php echo !empty($paid) ? __d('buzz_camps', 'Total Paid:') : __d('buzz_camps', 'Total:'); ?> <span class="large"><?php echo $this->Number->price($data['Camp']['cost']); ?></span></strong>
				</div>
			</div>

		</div>
	</div>
</div>
<div class="content__spacer"></div>
