<?php
$this->extend('/Common/2col');
$this->assign('title', $data['Camp']['name']);
$this->start('side');

echo $this->Fa->link('chevron-circle-left', __d('buzz_camps', 'Back to Camps'), ['action' => 'index'], ['class' => 'button button--fill button--back', 'before' => true]);

$this->end(); // side
?>

<?= $this->Html->para('intro', $data['Camp']['tag_line']); ?>

<div class="content__spacer"></div>

<div class="row">
	<?php $class = !empty($gallery) || !empty($data['Image'][0]['filename']) ? 'col-md-5_9' : ''; ?>
	<div class="col-xs-12 <?= $class; ?> text-center">

		<table class="table--centralised no-margin">
			<tbody>
				<tr>
					<th><?= __d('buzz_camps', 'Price'); ?>:</th>
					<td><?= $this->Number->currency($data['Camp']['cost']); ?></td>
				</tr>
				<tr>
					<th><?= __d('buzz_camps', 'Date'); ?>:</th>
					<td><?= $this->Time->i18nFormat($data['Camp']['date'], '%d/%m/%Y'); ?></td>
				</tr>
				<tr>
					<th><?= __d('buzz_camps', 'Time'); ?>:</th>
					<td><?= $data['Camp']['time']; ?></td>
				</tr>
				<?php if (! empty($site) && Configure::read('BuzzSites.show_location')): ?>
					<tr>
						<th><?= __d('buzz_camps', 'Location'); ?>:</th>
						<td><?= $this->I18n->translate($site, 'Site.name') ?></td>
					</tr>
				<?php endif; ?>
				<tr>
					<th><?= __d('buzz_camps', 'Spaces Available'); ?>:</th>
					<td><?= $data['Camp']['remaining_availability']; ?></td>
				</tr>
			</tbody>
		</table>

		<div class="content__spacer"></div>

		<?php if ($data['Camp']['remaining_availability'] > 0): ?>
			<?= $this->Fa->link('chevron-circle-right', __d('buzz_camps', 'Book Now'), ['controller' => 'camp_bookings', 'action' => 'book', $data['Camp']['id']], ['class' => 'button']); ?>
		<?php else: ?>
			<?= __d('buzz_camps', 'Sold Out') ?>
		<?php endif ?>

	</div>
	<?php if (!empty($data['Image'][0]['filename'])): ?>
		<div class="col-xs-12 col-md-4_9">
			<?= $this->Img->resize($data['Image'][0], ['width' => 800, 'height' => 432], ['class' => 'full']); ?>
		</div>
	<?php elseif (!empty($gallery)): ?>
		<div class="col-xs-12 col-md-4_9">
			<?= $this->element('BuzzGallery.mini_gallery', ['data' => $gallery['GalleryImage']]); ?>
		</div>
	<?php endif; ?>
</div>

<div class="content__spacer"></div>

<?php if (!empty($data['Camp']['description'])): ?>
	<h2 class="h3"><?= __d('buzz_camps', 'About the Camp'); ?></h2>
	<?= $this->Text->autoParagraph($data['Camp']['description']); ?>
<?php endif; ?>

<hr />

<div class="row listing">
	<div class="col-xs-12 col-sm-2_9">
		<?php
			$img = empty($data['AccountProfile']['Image'][0]['filename']) ? 'avatar.png' : $data['AccountProfile']['Image'][0];
			echo $this->Img->resize($img, ['width' => 468, 'height' => 356, 'crop' => true], ['class' => 'listing__image']);
		?>
	</div>
	<div class="content__spacer xs-visible"></div>
	<div class="col-xs-12 col-sm-5_9" itemscope itemtype="http://schema.org/Person">
		<h2 class="h3"><?= __d('buzz_camps', 'About %s', ['<span itemprop="name">' . $data['AccountProfile']['display_name'] . '</span>']); ?></h2>
		<ul class="fa-ul no-bullets">
			<?php if (!empty($data['AccountProfile']['contact_email'])): ?>
				<li><i class="fa-li fa fa-envelope"></i> <span itemprop="email"><?= $this->Text->autoLinkEmails($data['AccountProfile']['contact_email']); ?></span></li>
			<?php endif; ?>
			<?php if (!empty($data['AccountProfile']['contact_telephone'])): ?>
				<li><i class="fa-li fa fa-phone"></i> <span itemprop="telephone"><?= $data['AccountProfile']['contact_telephone']; ?></span></li>
			<?php endif; ?>
		</ul>

		<?= $this->Text->autoParagraph($data['AccountProfile']['description']); ?>
	</div>
	<div class="content__spacer"></div>
</div>
